/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.router.client.flow;

import com.tencent.polaris.api.config.Configuration;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.DefaultRouterChainGroup;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.loadbalance.LoadBalancer;
import com.tencent.polaris.api.plugin.route.RouteInfo;
import com.tencent.polaris.api.plugin.route.ServiceRouter;
import com.tencent.polaris.api.pojo.DefaultServiceEventKeysProvider;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.api.pojo.ServiceInstances;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.SourceService;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.api.utils.StringUtils;
import com.tencent.polaris.client.api.SDKContext;
import com.tencent.polaris.client.flow.BaseFlow;
import com.tencent.polaris.client.flow.DefaultFlowControlParam;
import com.tencent.polaris.client.flow.ResourcesResponse;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.router.api.flow.RouterFlow;
import com.tencent.polaris.router.api.rpc.ProcessLoadBalanceRequest;
import com.tencent.polaris.router.api.rpc.ProcessLoadBalanceResponse;
import com.tencent.polaris.router.api.rpc.ProcessRoutersRequest;
import com.tencent.polaris.router.api.rpc.ProcessRoutersResponse;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;

public class DefaultRouterFlow
implements RouterFlow {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRouterFlow.class);
    private Configuration config;
    private Extensions extensions;

    @Override
    public String getName() {
        return "default";
    }

    @Override
    public void setSDKContext(SDKContext sdkContext) {
        this.extensions = sdkContext.getExtensions();
        this.config = sdkContext.getConfig();
    }

    @Override
    public ProcessRoutersResponse processRouters(ProcessRoutersRequest request) {
        ProcessRoutersRequest.RouterNamesGroup requestRouterGroup = request.getRouters();
        List<ServiceRouter> beforeRouters = null != requestRouterGroup && CollectionUtils.isNotEmpty(requestRouterGroup.getBeforeRouters()) ? Extensions.loadServiceRouters(requestRouterGroup.getBeforeRouters(), this.extensions.getPlugins(), true) : this.extensions.getConfigRouterChainGroup().getBeforeRouters();
        List<ServiceRouter> afterRouters = null != requestRouterGroup && CollectionUtils.isNotEmpty(requestRouterGroup.getAfterRouters()) ? Extensions.loadServiceRouters(requestRouterGroup.getAfterRouters(), this.extensions.getPlugins(), true) : this.extensions.getConfigRouterChainGroup().getAfterRouters();
        List<ServiceRouter> coreRouters = null != requestRouterGroup && CollectionUtils.isNotEmpty(requestRouterGroup.getCoreRouters()) ? Extensions.loadServiceRouters(requestRouterGroup.getCoreRouters(), this.extensions.getPlugins(), true) : this.extensions.getConfigRouterChainGroup().getCoreRouters();
        ServiceInstances dstInstances = request.getDstInstances();
        SourceService sourceService = new SourceService();
        sourceService.setService(request.getSourceService().getService());
        sourceService.setNamespace(request.getSourceService().getNamespace());
        RouteInfo routeInfo = new RouteInfo(sourceService, dstInstances, request.getMethod(), this.config.getProvider().getService());
        routeInfo.setRouterArguments(request.getRouterArguments());
        if (request.getMetadataFailoverType() != null) {
            routeInfo.setMetadataFailoverType(request.getMetadataFailoverType());
        }
        DefaultFlowControlParam engineFlowControlParam = new DefaultFlowControlParam();
        BaseFlow.buildFlowControlParam(request, this.config, engineFlowControlParam);
        HashSet<ServiceEventKey> routerKeys = new HashSet<ServiceEventKey>();
        ServiceEventKey dstSvcEventKey = new ServiceEventKey(new ServiceKey(dstInstances.getNamespace(), dstInstances.getService()), ServiceEventKey.EventType.ROUTING);
        routerKeys.add(dstSvcEventKey);
        ServiceEventKey srcSvcEventKey = null;
        if (null != routeInfo.getSourceService() && StringUtils.isNotBlank(routeInfo.getSourceService().getNamespace()) && StringUtils.isNotBlank(routeInfo.getSourceService().getService())) {
            srcSvcEventKey = new ServiceEventKey(new ServiceKey(routeInfo.getSourceService().getNamespace(), routeInfo.getSourceService().getService()), ServiceEventKey.EventType.ROUTING);
            routerKeys.add(srcSvcEventKey);
        }
        DefaultServiceEventKeysProvider svcKeysProvider = new DefaultServiceEventKeysProvider();
        svcKeysProvider.setSvcEventKeys(routerKeys);
        ResourcesResponse resourcesResponse = BaseFlow.syncGetResources(this.extensions, false, svcKeysProvider, engineFlowControlParam);
        routeInfo.setDestRouteRule(resourcesResponse.getServiceRule(dstSvcEventKey));
        if (null != srcSvcEventKey) {
            routeInfo.setSourceRouteRule(resourcesResponse.getServiceRule(srcSvcEventKey));
        }
        DefaultRouterChainGroup routerChainGroup = new DefaultRouterChainGroup(beforeRouters, coreRouters, afterRouters);
        ServiceInstances svcInstances = BaseFlow.processServiceRouters(routeInfo, dstInstances, routerChainGroup);
        return new ProcessRoutersResponse(svcInstances);
    }

    @Override
    public ProcessLoadBalanceResponse processLoadBalance(ProcessLoadBalanceRequest request) {
        String lbPolicy = request.getLbPolicy();
        if (StringUtils.isBlank(lbPolicy)) {
            lbPolicy = this.extensions.getConfiguration().getConsumer().getLoadbalancer().getType();
        }
        LoadBalancer loadBalancer = (LoadBalancer)this.extensions.getPlugins().getPlugin(PluginTypes.LOAD_BALANCER.getBaseType(), lbPolicy);
        Instance instance = BaseFlow.processLoadBalance(loadBalancer, request.getCriteria(), request.getDstInstances());
        return new ProcessLoadBalanceResponse(instance);
    }
}

