/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.stat.prometheus.handler;

import com.sun.net.httpserver.HttpServer;
import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.stat.prometheus.handler.HttpMetricHandler;
import com.tencent.polaris.plugins.stat.prometheus.handler.PrometheusHandlerConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import shade.polaris.io.prometheus.client.CollectorRegistry;

public class PrometheusHttpServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PrometheusHttpServer.class);
    private static final String DEFAULT_PATH = "/metrics";
    private static final int MIN_RANDOM_PORT = 20000;
    private static final int MAX_RANDOM_PORT = 65535;
    private final HttpServer httpServer;
    private final ThreadFactory threadFactory;
    private final ExecutorService executor;
    private final String host;
    private int port;
    private String path;

    public PrometheusHttpServer(String host, int port, CollectorRegistry registry) {
        this(host, port, DEFAULT_PATH, registry);
    }

    public PrometheusHttpServer(String host, int port, String path, CollectorRegistry registry) {
        try {
            this.host = host;
            this.path = path;
            this.setServerPort(port);
            this.threadFactory = new DaemonNamedThreadFactory("prometheus-http");
            this.httpServer = HttpServer.create(new InetSocketAddress(this.host, this.port), 3);
            HttpMetricHandler metricHandler = new HttpMetricHandler(registry);
            this.httpServer.createContext("/", metricHandler);
            this.httpServer.createContext(path, metricHandler);
            this.httpServer.createContext("/-/healthy", metricHandler);
            this.executor = Executors.newFixedThreadPool(3, this.threadFactory);
            this.httpServer.setExecutor(this.executor);
            this.startServer();
        }
        catch (IOException e) {
            LOGGER.error("Create prometheus http server exception. host:{}, port:{}, path:{}", new Object[]{host, port, path, e});
            throw new UncheckedIOException("Create prometheus http server failed!", e);
        }
    }

    private void setServerPort(int port) {
        if (port == 0) {
            int randomPort = ThreadLocalRandom.current().nextInt(20000, 65535);
            while (!this.isPortAvailable(randomPort)) {
                randomPort = ThreadLocalRandom.current().nextInt(20000, 65535);
            }
            this.port = randomPort;
            return;
        }
        if (port == PrometheusHandlerConfig.DEFAULT_MIN_PULL_PORT) {
            for (int i = PrometheusHandlerConfig.DEFAULT_MIN_PULL_PORT.intValue(); i <= PrometheusHandlerConfig.DEFAULT_MAX_PULL_PORT; ++i) {
                if (!this.isPortAvailable(i)) continue;
                this.port = i;
                return;
            }
            String errMsg = String.format("prometheus http server port from %s to %d is used, please modify ${global.statReporter.plugin.prometheus.port} in polaris.yml", PrometheusHandlerConfig.DEFAULT_MIN_PULL_PORT, PrometheusHandlerConfig.DEFAULT_MAX_PULL_PORT);
            throw new PolarisException(ErrorCode.INTERNAL_ERROR, errMsg);
        }
        this.port = port;
        LOGGER.info("[Metrics][Prometheus] http-server listen port : {}", (Object)port);
    }

    private boolean isPortAvailable(int port) {
        try {
            this.bindPort(this.host, port);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void bindPort(String host, int port) throws IOException {
        try (Socket socket = new Socket();){
            socket.bind(new InetSocketAddress(host, port));
        }
    }

    private void startServer() {
        if (Thread.currentThread().isDaemon()) {
            this.httpServer.start();
            return;
        }
        Thread httpServerThread = this.threadFactory.newThread(this.httpServer::start);
        httpServerThread.start();
        try {
            httpServerThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void stopServer() {
        this.httpServer.stop(0);
        this.executor.shutdownNow();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    private static final class DaemonNamedThreadFactory
    extends NamedThreadFactory {
        public DaemonNamedThreadFactory(String component) {
            super(component);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread thread2 = super.newThread(r);
            thread2.setDaemon(true);
            return thread2;
        }
    }
}

