/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.replace;

import com.tencent.polaris.factory.util.PropertyPlaceholderHelper;
import com.tencent.polaris.logging.LoggerFactory;
import org.slf4j.Logger;

public class SystemPropertyPlaceholderResolver
implements PropertyPlaceholderHelper.PlaceholderResolver {
    private static final Logger logger = LoggerFactory.getLogger(PropertyPlaceholderHelper.class);

    @Override
    public String resolvePlaceholder(String placeholderName) {
        try {
            String propVal = System.getProperty(placeholderName);
            if (propVal == null) {
                propVal = System.getenv(placeholderName);
            }
            return propVal;
        }
        catch (Throwable ex) {
            logger.error("Could not resolve placeholder '" + placeholderName + " as system property: " + ex);
            return null;
        }
    }
}

