/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.provider;

import com.tencent.polaris.api.config.provider.RateLimitConfig;
import com.tencent.polaris.factory.config.plugin.PluginConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import java.util.List;
import shade.polaris.com.fasterxml.jackson.annotation.JsonProperty;

public class RateLimitConfigImpl
extends PluginConfigImpl
implements RateLimitConfig {
    @JsonProperty
    private Boolean enable;
    @JsonProperty
    private String limiterService;
    @JsonProperty
    private String limiterNamespace;
    @JsonProperty
    private List<String> limiterAddresses;
    @JsonProperty
    private Integer maxWindowCount;
    @JsonProperty
    private RateLimitConfig.Fallback fallbackOnExceedWindowCount;
    @JsonProperty
    private Long remoteSyncTimeoutMilli;
    @JsonProperty
    private Long maxQueuingTime;
    @JsonProperty
    private Boolean reportMetrics;

    @Override
    public boolean isEnable() {
        if (null == this.enable) {
            return false;
        }
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    @Override
    public int getMaxWindowCount() {
        if (null == this.maxWindowCount) {
            return 0;
        }
        return this.maxWindowCount;
    }

    public void setMaxWindowCount(int maxWindowCount) {
        this.maxWindowCount = maxWindowCount;
    }

    @Override
    public RateLimitConfig.Fallback getFallbackOnExceedWindowCount() {
        return this.fallbackOnExceedWindowCount;
    }

    public void setFallbackOnExceedWindowCount(RateLimitConfig.Fallback fallbackOnExceedWindowCount) {
        this.fallbackOnExceedWindowCount = fallbackOnExceedWindowCount;
    }

    @Override
    public String getLimiterService() {
        return this.limiterService;
    }

    public void setLimiterService(String limiterService) {
        this.limiterService = limiterService;
    }

    @Override
    public String getLimiterNamespace() {
        return this.limiterNamespace;
    }

    public void setLimiterNamespace(String limiterNamespace) {
        this.limiterNamespace = limiterNamespace;
    }

    @Override
    public List<String> getLimiterAddresses() {
        return this.limiterAddresses;
    }

    public void setLimiterAddresses(List<String> limiterAddresses) {
        this.limiterAddresses = limiterAddresses;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.enable, "rateLimit.enable");
        if (!this.enable.booleanValue()) {
            return;
        }
        ConfigUtils.validatePositive(this.maxWindowCount, "rateLimit.maxWindowCount");
        ConfigUtils.validateNull((Object)this.fallbackOnExceedWindowCount, "rateLimit.fallbackOnExceedWindowCount");
        this.verifyPluginConfig();
    }

    @Override
    public long getRemoteSyncTimeoutMilli() {
        return this.remoteSyncTimeoutMilli;
    }

    public void setRemoteSyncTimeoutMilli(long remoteSyncTimeoutMilli) {
        this.remoteSyncTimeoutMilli = remoteSyncTimeoutMilli;
    }

    @Override
    public long getMaxQueuingTime() {
        return this.maxQueuingTime;
    }

    public void setMaxQueuingTime(Long maxQueuingTime) {
        this.maxQueuingTime = maxQueuingTime;
    }

    @Override
    public boolean isReportMetrics() {
        if (null == this.reportMetrics) {
            return false;
        }
        return this.reportMetrics;
    }

    public void setReportMetrics(boolean reportMetrics) {
        this.reportMetrics = reportMetrics;
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null != defaultObject) {
            RateLimitConfig rateLimitConfig = (RateLimitConfig)defaultObject;
            if (null == this.enable) {
                this.setEnable(rateLimitConfig.isEnable());
            }
            if (null == this.maxWindowCount) {
                this.setMaxWindowCount(rateLimitConfig.getMaxWindowCount());
            }
            if (null == this.fallbackOnExceedWindowCount) {
                this.setFallbackOnExceedWindowCount(rateLimitConfig.getFallbackOnExceedWindowCount());
            }
            if (null == this.remoteSyncTimeoutMilli) {
                this.setRemoteSyncTimeoutMilli(rateLimitConfig.getRemoteSyncTimeoutMilli());
            }
            if (null == this.fallbackOnExceedWindowCount) {
                this.setFallbackOnExceedWindowCount(rateLimitConfig.getFallbackOnExceedWindowCount());
            }
            if (null == this.limiterNamespace) {
                this.setLimiterNamespace(rateLimitConfig.getLimiterNamespace());
            }
            if (null == this.limiterService) {
                this.setLimiterService(rateLimitConfig.getLimiterService());
            }
            if (null == this.maxQueuingTime) {
                this.setMaxQueuingTime(rateLimitConfig.getMaxQueuingTime());
            }
            if (null == this.reportMetrics) {
                this.setReportMetrics(rateLimitConfig.isReportMetrics());
            }
            this.setDefaultPluginConfig(rateLimitConfig);
        }
    }
}

