/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.factory.config.global;

import com.tencent.polaris.api.config.global.GlobalConfig;
import com.tencent.polaris.api.config.global.LocationConfig;
import com.tencent.polaris.api.utils.CollectionUtils;
import com.tencent.polaris.factory.config.global.APIConfigImpl;
import com.tencent.polaris.factory.config.global.LocationConfigImpl;
import com.tencent.polaris.factory.config.global.ServerConnectorConfigImpl;
import com.tencent.polaris.factory.config.global.StatReporterConfigImpl;
import com.tencent.polaris.factory.config.global.SystemConfigImpl;
import com.tencent.polaris.factory.util.ConfigUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import shade.polaris.com.fasterxml.jackson.annotation.JsonIgnore;
import shade.polaris.com.fasterxml.jackson.annotation.JsonProperty;

public class GlobalConfigImpl
implements GlobalConfig {
    @JsonProperty
    private SystemConfigImpl system;
    @JsonProperty
    private APIConfigImpl api;
    @JsonProperty
    private ServerConnectorConfigImpl serverConnector;
    @JsonProperty
    private List<ServerConnectorConfigImpl> serverConnectors;
    @JsonIgnore
    private Map<String, ServerConnectorConfigImpl> serverConnectorConfigMap = new ConcurrentHashMap<String, ServerConnectorConfigImpl>();
    @JsonProperty
    private StatReporterConfigImpl statReporter;
    @JsonProperty
    private LocationConfigImpl location;

    @Override
    public SystemConfigImpl getSystem() {
        return this.system;
    }

    @Override
    public APIConfigImpl getAPI() {
        return this.api;
    }

    @Override
    public ServerConnectorConfigImpl getServerConnector() {
        return this.serverConnector;
    }

    @Override
    public LocationConfig getLocation() {
        return this.location;
    }

    public void setServerConnector(ServerConnectorConfigImpl serverConnector) {
        this.serverConnector = serverConnector;
    }

    @Override
    public List<ServerConnectorConfigImpl> getServerConnectors() {
        return this.serverConnectors;
    }

    public void setServerConnectors(List<ServerConnectorConfigImpl> serverConnectors) {
        for (ServerConnectorConfigImpl serverConnectorConfig : serverConnectors) {
            if (this.serverConnectorConfigMap.containsKey(serverConnectorConfig.getId())) {
                throw new IllegalArgumentException(String.format("Server connector config of [%s] is already exist.", serverConnectorConfig.getId()));
            }
            this.serverConnectorConfigMap.put(serverConnectorConfig.getId(), serverConnectorConfig);
        }
        this.serverConnectors = serverConnectors;
    }

    public Map<String, ServerConnectorConfigImpl> getServerConnectorConfigMap() {
        return this.serverConnectorConfigMap;
    }

    @Override
    public StatReporterConfigImpl getStatReporter() {
        return this.statReporter;
    }

    @Override
    public void verify() {
        ConfigUtils.validateNull(this.system, "system");
        ConfigUtils.validateNull(this.api, "api");
        HashMap<String, Object> validateMap = new HashMap<String, Object>();
        validateMap.put("serverConnector", this.serverConnector);
        validateMap.put("serverConnectors", this.serverConnectors);
        ConfigUtils.validateAllNull(validateMap);
        ConfigUtils.validateNull(this.statReporter, "statReporter");
        this.system.verify();
        this.api.verify();
        if (CollectionUtils.isNotEmpty(this.serverConnectors)) {
            for (ServerConnectorConfigImpl serverConnectorConfig : this.serverConnectors) {
                serverConnectorConfig.verify();
            }
        } else {
            ConfigUtils.validateTrue("grpc".equals(this.serverConnector.getProtocol()), "The protocol of server connector(not server connectors) is polaris");
            this.serverConnector.verify();
            this.serverConnectorConfigMap.put(this.serverConnector.getId(), this.serverConnector);
        }
        this.statReporter.verify();
    }

    @Override
    public void setDefault(Object defaultObject) {
        if (null == this.system) {
            this.system = new SystemConfigImpl();
        }
        if (null == this.api) {
            this.api = new APIConfigImpl();
        }
        if (null == this.serverConnector) {
            this.serverConnector = new ServerConnectorConfigImpl();
        }
        if (null == this.statReporter) {
            this.statReporter = new StatReporterConfigImpl();
        }
        if (null == this.location) {
            this.location = new LocationConfigImpl();
        }
        if (null != defaultObject) {
            GlobalConfig globalConfig = (GlobalConfig)defaultObject;
            this.system.setDefault(globalConfig.getSystem());
            this.api.setDefault(globalConfig.getAPI());
            boolean ifInit = false;
            if (CollectionUtils.isNotEmpty(this.serverConnectors)) {
                for (ServerConnectorConfigImpl serverConnectorConfig : this.serverConnectors) {
                    if (!"grpc".equals(serverConnectorConfig.getProtocol())) continue;
                    serverConnectorConfig.setDefault(globalConfig.getServerConnector());
                    this.serverConnector = serverConnectorConfig;
                    ifInit = true;
                }
            }
            if (!ifInit) {
                this.serverConnector.setDefault(globalConfig.getServerConnector());
            }
            this.statReporter.setDefault(globalConfig.getStatReporter());
            this.location.setDefault(globalConfig.getLocation());
        }
    }

    public String toString() {
        return "GlobalConfigImpl{system=" + this.system + ", api=" + this.api + ", serverConnector=" + this.serverConnector + ", serverConnectors=" + this.serverConnectors + ", statReporter=" + this.statReporter + '}';
    }
}

