/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.api.control;

import com.tencent.polaris.api.exception.ErrorCode;
import com.tencent.polaris.api.exception.PolarisException;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Destroyable {
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    protected void doDestroy() {
    }

    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.doDestroy();
        }
    }

    public String getName() {
        return "Destroyable";
    }

    public boolean isDestroyed() {
        return this.destroyed.get();
    }

    protected void checkDestroyed() throws PolarisException {
        if (this.isDestroyed()) {
            throw new PolarisException(ErrorCode.INVALID_STATE, String.format("Plugin %s has been destroyed", this.getName()));
        }
    }
}

