/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.monitor;

import com.google.common.util.concurrent.AtomicDouble;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.monitor.NumberGauge;

public class DoubleGauge
extends NumberGauge {
    private final AtomicDouble number = new AtomicDouble(0.0);

    public DoubleGauge(MonitorConfig config) {
        super(config);
        this.setBackingNumber((Number)this.number);
    }

    public void set(Double n) {
        this.number.set(n.doubleValue());
    }

    public AtomicDouble getNumber() {
        return this.number;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleGauge that = (DoubleGauge)o;
        return this.getConfig().equals(that.getConfig()) && ((Number)this.getValue()).equals(that.getValue());
    }

    @Override
    public int hashCode() {
        int result = this.config.hashCode();
        int n = Double.valueOf(this.number.get()).hashCode();
        result = 31 * result + n;
        return result;
    }

    @Override
    public Number getValue(int pollerIdx) {
        return this.number.get();
    }
}

