/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.shenyu.admin.listener.DataChangedEvent;
import org.apache.shenyu.admin.model.vo.NamespacePluginVO;
import org.apache.shenyu.admin.service.AiProxyApiKeyService;
import org.apache.shenyu.admin.service.AppAuthService;
import org.apache.shenyu.admin.service.DiscoveryService;
import org.apache.shenyu.admin.service.DiscoveryUpstreamService;
import org.apache.shenyu.admin.service.MetaDataService;
import org.apache.shenyu.admin.service.NamespacePluginService;
import org.apache.shenyu.admin.service.PluginService;
import org.apache.shenyu.admin.service.RuleService;
import org.apache.shenyu.admin.service.SelectorService;
import org.apache.shenyu.admin.service.SyncDataService;
import org.apache.shenyu.admin.transfer.PluginTransfer;
import org.apache.shenyu.common.dto.BaseData;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.enums.ConfigGroupEnum;
import org.apache.shenyu.common.enums.DataEventTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
public class SyncDataServiceImpl
implements SyncDataService {
    private static final Logger LOG = LoggerFactory.getLogger(SyncDataServiceImpl.class);
    private final AppAuthService appAuthService;
    private final PluginService pluginService;
    private final NamespacePluginService namespacePluginService;
    private final SelectorService selectorService;
    private final RuleService ruleService;
    private final ApplicationEventPublisher eventPublisher;
    private final MetaDataService metaDataService;
    private final DiscoveryService discoveryService;
    private final DiscoveryUpstreamService discoveryUpstreamService;
    private final AiProxyApiKeyService aiProxyApiKeyService;

    public SyncDataServiceImpl(AppAuthService appAuthService, PluginService pluginService, NamespacePluginService namespacePluginService, SelectorService selectorService, RuleService ruleService, ApplicationEventPublisher eventPublisher, MetaDataService metaDataService, DiscoveryUpstreamService discoveryUpstreamService, DiscoveryService discoveryService, AiProxyApiKeyService aiProxyApiKeyService) {
        this.appAuthService = appAuthService;
        this.pluginService = pluginService;
        this.namespacePluginService = namespacePluginService;
        this.selectorService = selectorService;
        this.ruleService = ruleService;
        this.eventPublisher = eventPublisher;
        this.metaDataService = metaDataService;
        this.discoveryUpstreamService = discoveryUpstreamService;
        this.discoveryService = discoveryService;
        this.aiProxyApiKeyService = aiProxyApiKeyService;
    }

    public boolean syncAll(DataEventTypeEnum type) {
        this.appAuthService.syncData();
        List<PluginData> pluginDataList = this.namespacePluginService.listAll();
        Map<String, List<PluginData>> namespacePluginDataList = pluginDataList.stream().collect(Collectors.groupingBy(BaseData::getNamespaceId));
        namespacePluginDataList.values().forEach(p -> this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, type, (List<?>)p)));
        List<SelectorData> selectorDataList = this.selectorService.listAll();
        Map<String, List<SelectorData>> namespaceSelectorDataList = selectorDataList.stream().collect(Collectors.groupingBy(BaseData::getNamespaceId));
        namespaceSelectorDataList.values().forEach(s -> this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, type, (List<?>)s)));
        List<RuleData> ruleDataList = this.ruleService.listAll();
        Map<String, List<RuleData>> namespaceRuleDataList = ruleDataList.stream().collect(Collectors.groupingBy(BaseData::getNamespaceId));
        namespaceRuleDataList.values().forEach(r -> this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, type, (List<?>)r)));
        this.metaDataService.syncData();
        this.discoveryService.syncData();
        this.aiProxyApiKeyService.syncData();
        return true;
    }

    public boolean syncAllByNamespaceId(DataEventTypeEnum type, String namespaceId) {
        this.appAuthService.syncDataByNamespaceId(namespaceId);
        List<PluginData> pluginDataList = this.namespacePluginService.listAll(namespaceId);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, type, pluginDataList));
        List<SelectorData> selectorDataList = this.selectorService.listAllByNamespaceId(namespaceId);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, type, selectorDataList));
        List<RuleData> ruleDataList = this.ruleService.listAllByNamespaceId(namespaceId);
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, type, ruleDataList));
        this.metaDataService.syncDataByNamespaceId(namespaceId);
        this.discoveryService.syncDataByNamespaceId(namespaceId);
        this.aiProxyApiKeyService.syncDataByNamespaceId(namespaceId);
        return true;
    }

    public boolean syncPluginData(String id) {
        NamespacePluginVO namespacePluginVO = this.namespacePluginService.findById(id);
        if (Objects.isNull(namespacePluginVO) || Objects.isNull(namespacePluginVO.getId())) {
            LOG.error("namespace plugin is not existed");
            return false;
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.UPDATE, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(namespacePluginVO))));
        List<SelectorData> selectorDataList = this.selectorService.findByPluginIdAndNamespaceId(namespacePluginVO.getPluginId(), namespacePluginVO.getNamespaceId());
        if (!CollectionUtils.isEmpty(selectorDataList)) {
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.REFRESH, selectorDataList));
            List<String> selectorIdList = selectorDataList.stream().map(BaseData::getId).collect(Collectors.toList());
            for (String selectorId : selectorIdList) {
                this.discoveryUpstreamService.refreshBySelectorId(selectorId);
            }
            List<RuleData> allRuleDataList = this.ruleService.findBySelectorIdList(selectorIdList);
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, DataEventTypeEnum.REFRESH, allRuleDataList));
        }
        if (PluginEnum.AI_PROXY.getName().equalsIgnoreCase(namespacePluginVO.getName())) {
            LOG.info("[AiProxySync] syncPluginData trigger apikey refresh, namespaceId={}", (Object)namespacePluginVO.getNamespaceId());
            this.aiProxyApiKeyService.syncDataByNamespaceId(namespacePluginVO.getNamespaceId());
        }
        return true;
    }

    public boolean syncPluginData(String namespaceId, String pluginId) {
        NamespacePluginVO namespacePluginVO = this.namespacePluginService.findByNamespaceIdAndPluginId(namespaceId, pluginId);
        if (Objects.isNull(namespacePluginVO) || Objects.isNull(namespacePluginVO.getPluginId())) {
            LOG.error("namespace plugin is not existed");
            return false;
        }
        this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.PLUGIN, DataEventTypeEnum.UPDATE, Collections.singletonList(PluginTransfer.INSTANCE.mapToData(namespacePluginVO))));
        List<SelectorData> selectorDataList = this.selectorService.findByPluginIdAndNamespaceId(namespacePluginVO.getPluginId(), namespacePluginVO.getNamespaceId());
        if (!CollectionUtils.isEmpty(selectorDataList)) {
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.SELECTOR, DataEventTypeEnum.REFRESH, selectorDataList));
            List<String> selectorIdList = selectorDataList.stream().map(BaseData::getId).collect(Collectors.toList());
            for (String selectorId : selectorIdList) {
                this.discoveryUpstreamService.refreshBySelectorId(selectorId);
            }
            List<RuleData> allRuleDataList = this.ruleService.findBySelectorIdList(selectorIdList);
            this.eventPublisher.publishEvent((ApplicationEvent)new DataChangedEvent(ConfigGroupEnum.RULE, DataEventTypeEnum.REFRESH, allRuleDataList));
        }
        if (PluginEnum.AI_PROXY.getName().equalsIgnoreCase(namespacePluginVO.getName())) {
            LOG.info("[AiProxySync] syncPluginData(ns,plugin) trigger apikey refresh, namespaceId={}", (Object)namespaceId);
            this.aiProxyApiKeyService.syncDataByNamespaceId(namespaceId);
        }
        return true;
    }
}

