/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.model.vo.EnumVO;
import org.apache.shenyu.admin.service.EnumService;
import org.apache.shenyu.common.enums.HttpMethodEnum;
import org.apache.shenyu.common.enums.HystrixIsolationModeEnum;
import org.apache.shenyu.common.enums.LoadBalanceEnum;
import org.apache.shenyu.common.enums.MatchModeEnum;
import org.apache.shenyu.common.enums.OperatorEnum;
import org.apache.shenyu.common.enums.ParamTypeEnum;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.enums.PluginTypeEnum;
import org.apache.shenyu.common.enums.RedisModeEnum;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.enums.SelectorTypeEnum;
import org.apache.shenyu.common.enums.SerializeEnum;
import org.apache.shenyu.common.enums.WafEnum;
import org.springframework.stereotype.Service;

@Service
public class EnumServiceImpl
implements EnumService {
    @Override
    public Map<String, List<EnumVO>> list() {
        List httpMethodEnums = Arrays.stream(HttpMethodEnum.values()).map(httpMethodEnum -> new EnumVO(null, httpMethodEnum.getName(), httpMethodEnum.getSupport())).collect(Collectors.toList());
        List loadBalanceEnums = Arrays.stream(LoadBalanceEnum.values()).map(loadBalanceEnum -> new EnumVO(loadBalanceEnum.getCode(), loadBalanceEnum.getName(), true)).collect(Collectors.toList());
        List matchModeEnums = Arrays.stream(MatchModeEnum.values()).map(matchModeEnum -> new EnumVO(matchModeEnum.getCode(), matchModeEnum.getName(), true)).collect(Collectors.toList());
        List operatorEnums = OperatorEnum.acquireSupport().stream().map(operatorEnum -> new EnumVO(null, operatorEnum.getAlias(), operatorEnum.getSupport())).collect(Collectors.toList());
        List paramTypeEnums = ParamTypeEnum.acquireSupport().stream().map(paramTypeEnum -> new EnumVO(null, paramTypeEnum.getName(), paramTypeEnum.getSupport())).collect(Collectors.toList());
        List pluginEnums = Arrays.stream(PluginEnum.values()).map(pluginEnum -> new EnumVO(pluginEnum.getCode(), pluginEnum.getName(), true)).collect(Collectors.toList());
        List pluginTypeEnums = Arrays.stream(PluginTypeEnum.values()).map(pluginTypeEnum -> new EnumVO(null, pluginTypeEnum.getName(), true)).collect(Collectors.toList());
        List rpcTypeEnums = RpcTypeEnum.acquireSupports().stream().map(rpcTypeEnum -> new EnumVO(null, rpcTypeEnum.getName(), rpcTypeEnum.getSupport())).collect(Collectors.toList());
        List selectorTypeEnums = Arrays.stream(SelectorTypeEnum.values()).map(selectorTypeEnum -> new EnumVO(selectorTypeEnum.getCode(), selectorTypeEnum.getName(), true)).collect(Collectors.toList());
        List serializeEnums = Arrays.stream(SerializeEnum.values()).map(serializeEnum -> new EnumVO(null, serializeEnum.getSerialize(), true)).collect(Collectors.toList());
        List wafEnums = Arrays.stream(WafEnum.values()).map(wafEnum -> new EnumVO(wafEnum.getCode(), wafEnum.getName(), true)).collect(Collectors.toList());
        List redisModeEnums = Arrays.stream(RedisModeEnum.values()).map(redisModeEnum -> new EnumVO(null, redisModeEnum.getName(), true)).collect(Collectors.toList());
        List hystrixIsolationModeEnums = Arrays.stream(HystrixIsolationModeEnum.values()).map(hystrixIsolationModeEnum -> new EnumVO(hystrixIsolationModeEnum.getCode(), hystrixIsolationModeEnum.getName(), true)).collect(Collectors.toList());
        HashMap enums = Maps.newHashMap();
        enums.put("httpMethodEnums", httpMethodEnums);
        enums.put("loadBalanceEnums", loadBalanceEnums);
        enums.put("matchModeEnums", matchModeEnums);
        enums.put("operatorEnums", operatorEnums);
        enums.put("paramTypeEnums", paramTypeEnums);
        enums.put("pluginEnums", pluginEnums);
        enums.put("pluginTypeEnums", pluginTypeEnums);
        enums.put("rpcTypeEnums", rpcTypeEnums);
        enums.put("selectorTypeEnums", selectorTypeEnums);
        enums.put("serializeEnums", serializeEnums);
        enums.put("wafEnums", wafEnums);
        enums.put("redisModeEnums", redisModeEnums);
        enums.put("hystrixIsolationModeEnums", hystrixIsolationModeEnums);
        return enums;
    }
}

