/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.service.impl;

import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.shenyu.admin.aspect.annotation.Pageable;
import org.apache.shenyu.admin.mapper.AlertReceiverMapper;
import org.apache.shenyu.admin.model.entity.AlertReceiverDO;
import org.apache.shenyu.admin.model.page.CommonPager;
import org.apache.shenyu.admin.model.page.PageResultUtils;
import org.apache.shenyu.admin.model.query.AlertReceiverQuery;
import org.apache.shenyu.admin.service.AlertDispatchService;
import org.apache.shenyu.admin.service.AlertReceiverService;
import org.apache.shenyu.admin.transfer.AlertTransfer;
import org.apache.shenyu.alert.model.AlertReceiverDTO;
import org.apache.shenyu.common.dto.AlarmContent;
import org.apache.shenyu.common.utils.UUIDUtils;
import org.springframework.stereotype.Service;

@Service
public class AlertReceiverServiceImpl
implements AlertReceiverService {
    private static final String ALERT_TEST_TITLE = "Alarm Test";
    private static final String ALERT_TEST_CONTENT = "test send msg! \n This is the test data. It is proved that it can be received successfully";
    private final AlertReceiverMapper alertReceiverMapper;
    private final AlertDispatchService alertDispatchService;

    public AlertReceiverServiceImpl(AlertReceiverMapper alertReceiverMapper, AlertDispatchService alertDispatchService) {
        this.alertReceiverMapper = alertReceiverMapper;
        this.alertDispatchService = alertDispatchService;
    }

    @Override
    public void addReceiver(AlertReceiverDTO alertReceiverDTO) {
        AlertReceiverDO receiverDO = AlertTransfer.INSTANCE.mapToAlertReceiverDO(alertReceiverDTO);
        receiverDO.setId(UUIDUtils.getInstance().generateShortUuid());
        Timestamp currentTime = new Timestamp(System.currentTimeMillis());
        receiverDO.setDateCreated(currentTime);
        receiverDO.setDateUpdated(currentTime);
        this.alertReceiverMapper.insert(receiverDO);
        this.alertDispatchService.clearCache();
    }

    @Override
    public void deleteReceiver(List<String> ids) {
        this.alertReceiverMapper.deleteByIds(ids);
        this.alertDispatchService.clearCache();
    }

    @Override
    public void updateReceiver(AlertReceiverDTO alertReceiverDTO) {
        AlertReceiverDO receiverDO = AlertTransfer.INSTANCE.mapToAlertReceiverDO(alertReceiverDTO);
        this.alertReceiverMapper.updateByPrimaryKey(receiverDO);
        this.alertDispatchService.clearCache();
    }

    @Override
    public List<AlertReceiverDTO> getAll() {
        return this.alertReceiverMapper.selectAll();
    }

    @Override
    @Pageable
    public CommonPager<AlertReceiverDTO> listByPage(AlertReceiverQuery receiverQuery) {
        return PageResultUtils.result(receiverQuery.getPageParameter(), () -> this.alertReceiverMapper.selectByQuery(receiverQuery).stream().map(AlertTransfer.INSTANCE::mapToAlertReceiverDTO).collect(Collectors.toList()));
    }

    @Override
    public AlertReceiverDTO detail(String id) {
        AlertReceiverDO receiverDO = this.alertReceiverMapper.selectByPrimaryKey(id);
        if (Objects.nonNull(receiverDO)) {
            return AlertTransfer.INSTANCE.mapToAlertReceiverDTO(receiverDO);
        }
        return null;
    }

    @Override
    public boolean sendTestMsg(AlertReceiverDTO alertReceiverDTO) {
        AlarmContent content = new AlarmContent.Builder().title(ALERT_TEST_TITLE).content(ALERT_TEST_CONTENT).level((byte)2).dateCreated(new Date()).dateUpdated(new Date()).build();
        return this.alertDispatchService.sendNoticeMsg(alertReceiverDTO, content);
    }
}

