/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.mybatis.oracle;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.shenyu.common.utils.ReflectUtils;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class OracleSQLUpdateInterceptor
implements Interceptor {
    private static final List<String> AUTOMATIC_DATES = ImmutableList.of((Object)"dateUpdated");

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        Object parameter = args[1];
        Executor executor = (Executor)invocation.getTarget();
        for (Class<?> superClass = parameter.getClass(); superClass != Object.class; superClass = superClass.getSuperclass()) {
            Arrays.stream(superClass.getDeclaredFields()).filter(f -> this.matchParam(parameter, (Field)f)).forEach(f -> ReflectUtils.setFieldValue((Object)parameter, (String)f.getName(), (Object)new Timestamp(System.currentTimeMillis())));
        }
        return executor.update(ms, parameter);
    }

    private boolean matchParam(Object parameter, Field f) {
        return AUTOMATIC_DATES.contains(f.getName()) && Objects.isNull(ReflectUtils.getFieldValue((Object)parameter, (Field)f));
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

