/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.admin.listener.websocket;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.websocket.HandshakeResponse;
import jakarta.websocket.server.HandshakeRequest;
import jakarta.websocket.server.ServerEndpointConfig;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.admin.config.properties.WebsocketSyncProperties;
import org.apache.shenyu.admin.spring.SpringBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.context.annotation.Configuration;

@ConditionalOnProperty(name={"shenyu.sync.websocket.enabled"}, havingValue="true", matchIfMissing=true)
@Configuration
public class WebsocketConfigurator
extends ServerEndpointConfig.Configurator
implements ServletContextInitializer {
    private static final Logger LOG = LoggerFactory.getLogger(WebsocketConfigurator.class);
    @Autowired
    private WebsocketSyncProperties websocketSyncProperties;

    public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
        HttpSession httpSession = (HttpSession)request.getHttpSession();
        sec.getUserProperties().put("ClientIP", httpSession.getAttribute("ClientIP"));
        sec.getUserProperties().put("ClientPort", httpSession.getAttribute("ClientPort"));
        sec.getUserProperties().put("namespaceId", httpSession.getAttribute("namespaceId"));
        super.modifyHandshake(sec, request, response);
    }

    public boolean checkOrigin(String originHeaderValue) {
        WebsocketSyncProperties bean = SpringBeanUtils.getInstance().getBean(WebsocketSyncProperties.class);
        if (StringUtils.isNotEmpty((CharSequence)bean.getAllowOrigins())) {
            String[] split;
            for (String configAllow : split = StringUtils.split((String)bean.getAllowOrigins(), (String)";")) {
                if (!StringUtils.equals((CharSequence)configAllow, (CharSequence)originHeaderValue)) continue;
                return true;
            }
            LOG.error("originHeaderValue is forbidden: {}", (Object)originHeaderValue);
            return false;
        }
        return super.checkOrigin(originHeaderValue);
    }

    public void onStartup(ServletContext servletContext) {
        int messageMaxSize = this.websocketSyncProperties.getMessageMaxSize();
        if (messageMaxSize > 0) {
            servletContext.setInitParameter("org.apache.tomcat.websocket.textBufferSize", String.valueOf(messageMaxSize));
            servletContext.setInitParameter("org.apache.tomcat.websocket.binaryBufferSize", String.valueOf(messageMaxSize));
        }
    }
}

