/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net.openssl.panama;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.openssl.OpenSSLStatus;
import org.apache.tomcat.util.net.openssl.ciphers.OpenSSLCipherConfigurationParser;
import org.apache.tomcat.util.openssl.openssl_h;
import org.apache.tomcat.util.openssl.openssl_h_Compatibility;
import org.apache.tomcat.util.res.StringManager;

public class OpenSSLLibrary {
    private static final Log log = LogFactory.getLog(OpenSSLLibrary.class);
    protected static final StringManager sm = StringManager.getManager(OpenSSLLibrary.class);
    protected static String SSLEngine = "on";
    protected static String FIPSMode = "off";
    protected static String SSLRandomSeed = "builtin";
    protected static boolean fipsModeActive = false;
    private static final int FIPS_ON = 1;
    private static final int FIPS_OFF = 0;
    protected static final Object lock = new Object();
    private static int referenceCount = 0;
    static MemorySegment enginePointer = MemorySegment.NULL;
    static final DHParam[] dhParameters = new DHParam[6];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initLibrary() {
        Object object = lock;
        synchronized (object) {
            if (OpenSSLStatus.isLibraryInitialized()) {
                return;
            }
            long initParam = openssl_h.OpenSSL_version_num() >= 0x3000000FL ? 0L : openssl_h.OPENSSL_INIT_ENGINE_ALL_BUILTIN();
            openssl_h.OPENSSL_init_ssl(initParam, MemorySegment.NULL);
            OpenSSLStatus.setLibraryInitialized(true);
        }
    }

    private static void initDHParameters() {
        MemorySegment dh2 = openssl_h.DH_new();
        MemorySegment p = openssl_h.BN_get_rfc3526_prime_8192(MemorySegment.NULL);
        MemorySegment g = openssl_h.BN_new();
        openssl_h.BN_set_word(g, 2L);
        openssl_h.DH_set0_pqg(dh2, p, MemorySegment.NULL, g);
        OpenSSLLibrary.dhParameters[0] = new DHParam(dh2, 6145);
        dh2 = openssl_h.DH_new();
        p = openssl_h.BN_get_rfc3526_prime_6144(MemorySegment.NULL);
        g = openssl_h.BN_new();
        openssl_h.BN_set_word(g, 2L);
        openssl_h.DH_set0_pqg(dh2, p, MemorySegment.NULL, g);
        OpenSSLLibrary.dhParameters[1] = new DHParam(dh2, 4097);
        dh2 = openssl_h.DH_new();
        p = openssl_h.BN_get_rfc3526_prime_4096(MemorySegment.NULL);
        g = openssl_h.BN_new();
        openssl_h.BN_set_word(g, 2L);
        openssl_h.DH_set0_pqg(dh2, p, MemorySegment.NULL, g);
        OpenSSLLibrary.dhParameters[2] = new DHParam(dh2, 3073);
        dh2 = openssl_h.DH_new();
        p = openssl_h.BN_get_rfc3526_prime_3072(MemorySegment.NULL);
        g = openssl_h.BN_new();
        openssl_h.BN_set_word(g, 2L);
        openssl_h.DH_set0_pqg(dh2, p, MemorySegment.NULL, g);
        OpenSSLLibrary.dhParameters[3] = new DHParam(dh2, 2049);
        dh2 = openssl_h.DH_new();
        p = openssl_h.BN_get_rfc3526_prime_2048(MemorySegment.NULL);
        g = openssl_h.BN_new();
        openssl_h.BN_set_word(g, 2L);
        openssl_h.DH_set0_pqg(dh2, p, MemorySegment.NULL, g);
        OpenSSLLibrary.dhParameters[4] = new DHParam(dh2, 1025);
        dh2 = openssl_h.DH_new();
        p = openssl_h.BN_get_rfc2409_prime_1024(MemorySegment.NULL);
        g = openssl_h.BN_new();
        openssl_h.BN_set_word(g, 2L);
        openssl_h.DH_set0_pqg(dh2, p, MemorySegment.NULL, g);
        OpenSSLLibrary.dhParameters[5] = new DHParam(dh2, 0);
    }

    private static void freeDHParameters() {
        for (int i = 0; i < dhParameters.length; ++i) {
            MemorySegment dh2;
            if (dhParameters[i] == null || (dh2 = OpenSSLLibrary.dhParameters[i].dh) == null || MemorySegment.NULL.equals(dh2)) continue;
            openssl_h.DH_free(dh2);
            OpenSSLLibrary.dhParameters[i] = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void init() {
        Object object = lock;
        synchronized (object) {
            if (referenceCount++ != 0) {
                return;
            }
            if (OpenSSLStatus.isInitialized()) {
                return;
            }
            OpenSSLStatus.setInitialized(true);
            if ("off".equalsIgnoreCase(SSLEngine)) {
                return;
            }
            try (Arena memorySession = Arena.ofConfined();){
                String engineName;
                OpenSSLLibrary.initLibrary();
                boolean isOpenSSL3 = openssl_h.OpenSSL_version_num() >= 0x3000000FL;
                String string = engineName = "on".equalsIgnoreCase(SSLEngine) ? null : SSLEngine;
                if (!isOpenSSL3 && engineName != null) {
                    if ("auto".equals(engineName)) {
                        openssl_h.ENGINE_register_all_complete();
                    } else {
                        MemorySegment engine = memorySession.allocateFrom(engineName);
                        enginePointer = openssl_h.ENGINE_by_id(engine);
                        if (MemorySegment.NULL.equals(enginePointer) && (enginePointer = openssl_h.ENGINE_by_id(memorySession.allocateFrom("dynamic"))) != null && (openssl_h.ENGINE_ctrl_cmd_string(enginePointer, memorySession.allocateFrom("SO_PATH"), engine, 0) == 0 || openssl_h.ENGINE_ctrl_cmd_string(enginePointer, memorySession.allocateFrom("LOAD"), MemorySegment.NULL, 0) == 0)) {
                            openssl_h.ENGINE_free(enginePointer);
                            enginePointer = MemorySegment.NULL;
                        }
                        if (!MemorySegment.NULL.equals(enginePointer) && openssl_h.ENGINE_set_default(enginePointer, openssl_h.ENGINE_METHOD_ALL()) == 0) {
                            openssl_h.ENGINE_free(enginePointer);
                            enginePointer = MemorySegment.NULL;
                        }
                        if (MemorySegment.NULL.equals(enginePointer)) {
                            throw new IllegalStateException(sm.getString("openssllibrary.engineError"));
                        }
                    }
                }
                boolean seedDone = false;
                if (SSLRandomSeed != null || SSLRandomSeed.length() != 0 || !"builtin".equals(SSLRandomSeed)) {
                    MemorySegment randomSeed = memorySession.allocateFrom(SSLRandomSeed);
                    boolean bl = seedDone = openssl_h.RAND_load_file(randomSeed, 128L) > 0;
                }
                if (!seedDone) {
                    SecureRandom random = new SecureRandom();
                    byte[] randomBytes = random.generateSeed(128);
                    openssl_h.RAND_seed(memorySession.allocateFrom(ValueLayout.JAVA_BYTE, randomBytes), 128);
                }
                if (!isOpenSSL3) {
                    OpenSSLLibrary.initDHParameters();
                }
                if (isOpenSSL3 || null != FIPSMode && !"off".equalsIgnoreCase(FIPSMode)) {
                    boolean enterFipsMode;
                    fipsModeActive = false;
                    int fipsModeState = 0;
                    if (isOpenSSL3) {
                        MemorySegment md = openssl_h.EVP_MD_fetch(MemorySegment.NULL, memorySession.allocateFrom("SHA-512"), MemorySegment.NULL);
                        MemorySegment provider = openssl_h.EVP_MD_get0_provider(md);
                        String name = openssl_h.OSSL_PROVIDER_get0_name(provider).getString(0L);
                        openssl_h.EVP_MD_free(md);
                        if ("fips".equals(name)) {
                            fipsModeState = 1;
                        }
                    } else {
                        fipsModeState = openssl_h_Compatibility.FIPS_mode();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(sm.getString("openssllibrary.currentFIPSMode", fipsModeState));
                    }
                    if (null == FIPSMode || "off".equalsIgnoreCase(FIPSMode)) {
                        if (fipsModeState == 1) {
                            fipsModeActive = true;
                        }
                        enterFipsMode = false;
                    } else if ("on".equalsIgnoreCase(FIPSMode)) {
                        if (fipsModeState == 1) {
                            if (!isOpenSSL3) {
                                log.info(sm.getString("openssllibrary.skipFIPSInitialization"));
                            }
                            fipsModeActive = true;
                            enterFipsMode = false;
                        } else {
                            if (isOpenSSL3) {
                                throw new IllegalStateException(sm.getString("openssllibrary.FIPSProviderNotDefault", FIPSMode));
                            }
                            enterFipsMode = true;
                        }
                    } else if ("require".equalsIgnoreCase(FIPSMode)) {
                        if (fipsModeState != 1) {
                            if (!isOpenSSL3) throw new IllegalStateException(sm.getString("openssllibrary.requireNotInFIPSMode"));
                            throw new IllegalStateException(sm.getString("openssllibrary.FIPSProviderNotDefault", FIPSMode));
                        }
                        fipsModeActive = true;
                        enterFipsMode = false;
                    } else {
                        if (!"enter".equalsIgnoreCase(FIPSMode)) {
                            throw new IllegalArgumentException(sm.getString("openssllibrary.wrongFIPSMode", FIPSMode));
                        }
                        if (fipsModeState == 0) {
                            if (isOpenSSL3) {
                                throw new IllegalStateException(sm.getString("openssllibrary.FIPSProviderNotDefault", FIPSMode));
                            }
                            enterFipsMode = true;
                        } else {
                            if (!isOpenSSL3) {
                                throw new IllegalStateException(sm.getString("openssllibrary.enterAlreadyInFIPSMode", fipsModeState));
                            }
                            fipsModeActive = true;
                            enterFipsMode = false;
                        }
                    }
                    if (enterFipsMode) {
                        log.info(sm.getString("openssllibrary.initializingFIPS"));
                        fipsModeState = openssl_h_Compatibility.FIPS_mode_set(1);
                        if (fipsModeState != 1) {
                            String message = sm.getString("openssllibrary.initializeFIPSFailed");
                            log.error(message);
                            throw new IllegalStateException(message);
                        }
                        fipsModeActive = true;
                        log.info(sm.getString("openssllibrary.initializeFIPSSuccess"));
                    }
                    if (isOpenSSL3 && fipsModeActive) {
                        log.info(sm.getString("aprListener.usingFIPSProvider"));
                    }
                }
                log.info(sm.getString("openssllibrary.initializedOpenSSL", openssl_h.OpenSSL_version(0).getString(0L)));
                OpenSSLStatus.setAvailable(true);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy() {
        Object object = lock;
        synchronized (object) {
            if (--referenceCount != 0) {
                return;
            }
            if (!OpenSSLStatus.isInitialized()) {
                return;
            }
            OpenSSLStatus.setAvailable(false);
            try {
                if (openssl_h.OpenSSL_version_num() < 0x3000000FL) {
                    OpenSSLLibrary.freeDHParameters();
                    if (!MemorySegment.NULL.equals(enginePointer)) {
                        openssl_h.ENGINE_free(enginePointer);
                        enginePointer = MemorySegment.NULL;
                    }
                    openssl_h_Compatibility.FIPS_mode_set(0);
                }
            }
            finally {
                OpenSSLStatus.setInitialized(false);
                fipsModeActive = false;
            }
        }
    }

    public static String getSSLEngine() {
        return SSLEngine;
    }

    public static void setSSLEngine(String SSLEngine2) {
        if (!SSLEngine2.equals(SSLEngine)) {
            if (OpenSSLStatus.isInitialized()) {
                throw new IllegalStateException(sm.getString("openssllibrary.tooLateForSSLEngine"));
            }
            SSLEngine = SSLEngine2;
        }
    }

    public static String getSSLRandomSeed() {
        return SSLRandomSeed;
    }

    public static void setSSLRandomSeed(String SSLRandomSeed) {
        if (!SSLRandomSeed.equals(OpenSSLLibrary.SSLRandomSeed)) {
            if (OpenSSLStatus.isInitialized()) {
                throw new IllegalStateException(sm.getString("openssllibrary.tooLateForSSLRandomSeed"));
            }
            OpenSSLLibrary.SSLRandomSeed = SSLRandomSeed;
        }
    }

    public static String getFIPSMode() {
        return FIPSMode;
    }

    public static void setFIPSMode(String FIPSMode) {
        if (!FIPSMode.equals(OpenSSLLibrary.FIPSMode)) {
            if (OpenSSLStatus.isInitialized()) {
                throw new IllegalStateException(sm.getString("openssllibrary.tooLateForFIPSMode"));
            }
            OpenSSLLibrary.FIPSMode = FIPSMode;
        }
    }

    public static boolean isFIPSModeActive() {
        return fipsModeActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> findCiphers(String ciphers) {
        ArrayList<String> ciphersList = new ArrayList<String>();
        try (Arena localArena = Arena.ofConfined();){
            OpenSSLLibrary.initLibrary();
            MemorySegment sslCtx = openssl_h.SSL_CTX_new(openssl_h.TLS_server_method());
            try {
                openssl_h.SSL_CTX_set_options(sslCtx, openssl_h.SSL_OP_ALL());
                openssl_h.SSL_CTX_set_cipher_list(sslCtx, localArena.allocateFrom(ciphers));
                MemorySegment ssl = openssl_h.SSL_new(sslCtx);
                openssl_h.SSL_set_accept_state(ssl);
                try {
                    for (String c : OpenSSLLibrary.getCiphers(ssl)) {
                        if (c == null || c.length() == 0 || ciphersList.contains(c)) continue;
                        ciphersList.add(OpenSSLCipherConfigurationParser.openSSLToJsse(c));
                    }
                }
                finally {
                    openssl_h.SSL_free(ssl);
                }
            }
            finally {
                openssl_h.SSL_CTX_free(sslCtx);
            }
        }
        catch (Exception e) {
            log.warn(sm.getString("openssllibrary.ciphersFailure"), e);
        }
        return ciphersList;
    }

    static String[] getCiphers(MemorySegment ssl) {
        MemorySegment sk = openssl_h.SSL_get_ciphers(ssl);
        int len = openssl_h.OPENSSL_sk_num(sk);
        if (len <= 0) {
            return null;
        }
        ArrayList<String> ciphers = new ArrayList<String>(len);
        for (int i = 0; i < len; ++i) {
            MemorySegment cipher = openssl_h.OPENSSL_sk_value(sk, i);
            MemorySegment cipherName = openssl_h.SSL_CIPHER_get_name(cipher);
            ciphers.add(cipherName.getString(0L));
        }
        return ciphers.toArray(new String[0]);
    }

    static final class DHParam {
        final MemorySegment dh;
        final int min;

        private DHParam(MemorySegment dh2, int min) {
            this.dh = dh2;
            this.min = min;
        }
    }
}

