/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.ResolvableType;
import org.springframework.expression.common.LiteralExpression;
import org.springframework.integration.config.ExpressionFactoryBean;
import org.springframework.integration.config.IntegrationConfigUtils;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.gateway.GatewayMethodMetadata;
import org.springframework.integration.gateway.GatewayProxyFactoryBean;
import org.springframework.integration.gateway.RequestReplyExchanger;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class GatewayParser
implements BeanDefinitionParser {
    private static final String PROXY_DEFAULT_METHODS_ATTR = "proxyDefaultMethods";
    private static final String ASYNC_EXECUTOR_ATTR = "asyncExecutor";
    private static final String MAPPER_ATTR = "mapper";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        boolean isNested = parserContext.isNested();
        HashMap<String, Object> gatewayAttributes = new HashMap<String, Object>();
        gatewayAttributes.put("name", element.getAttribute("id"));
        gatewayAttributes.put("defaultPayloadExpression", element.getAttribute("default-payload-expression"));
        gatewayAttributes.put("defaultRequestChannel", element.getAttribute(isNested ? "request-channel" : "default-request-channel"));
        gatewayAttributes.put("defaultReplyChannel", element.getAttribute(isNested ? "reply-channel" : "default-reply-channel"));
        gatewayAttributes.put("errorChannel", element.getAttribute("error-channel"));
        String asyncExecutor = element.getAttribute("async-executor");
        if (!element.hasAttribute("async-executor") || StringUtils.hasLength((String)asyncExecutor)) {
            gatewayAttributes.put(ASYNC_EXECUTOR_ATTR, asyncExecutor);
        } else {
            gatewayAttributes.put(ASYNC_EXECUTOR_ATTR, null);
        }
        gatewayAttributes.put(MAPPER_ATTR, element.getAttribute(MAPPER_ATTR));
        gatewayAttributes.put("defaultReplyTimeout", element.getAttribute(isNested ? "reply-timeout" : "default-reply-timeout"));
        gatewayAttributes.put("defaultRequestTimeout", element.getAttribute(isNested ? "request-timeout" : "default-request-timeout"));
        GatewayParser.headers(element, gatewayAttributes);
        GatewayParser.methods(element, parserContext, gatewayAttributes);
        gatewayAttributes.put("serviceInterface", element.getAttribute("service-interface"));
        gatewayAttributes.put(PROXY_DEFAULT_METHODS_ATTR, element.getAttribute("proxy-default-methods"));
        BeanDefinitionHolder gatewayHolder = GatewayParser.buildBeanDefinition(gatewayAttributes, parserContext);
        if (isNested) {
            return gatewayHolder.getBeanDefinition();
        }
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)gatewayHolder, (BeanDefinitionRegistry)parserContext.getRegistry());
        return null;
    }

    private static void headers(Element element, Map<String, Object> gatewayAttributes) {
        List headerElements = DomUtils.getChildElementsByTagName((Element)element, (String)"default-header");
        if (!CollectionUtils.isEmpty((Collection)headerElements)) {
            ArrayList headers = new ArrayList(headerElements.size());
            for (Element e : headerElements) {
                HashMap<String, String> header = new HashMap<String, String>();
                header.put("name", e.getAttribute("name"));
                header.put("value", e.getAttribute("value"));
                header.put("expression", e.getAttribute("expression"));
                headers.add(header);
            }
            gatewayAttributes.put("defaultHeaders", headers.toArray(new Map[0]));
        }
    }

    private static void methods(Element element, ParserContext parserContext, Map<String, Object> gatewayAttributes) {
        List methodElements = DomUtils.getChildElementsByTagName((Element)element, (String)"method");
        if (!CollectionUtils.isEmpty((Collection)methodElements)) {
            ManagedMap methodMetadataMap = new ManagedMap();
            for (Element methodElement : methodElements) {
                List invocationHeaders;
                String methodName = methodElement.getAttribute("name");
                BeanDefinitionBuilder methodMetadataBuilder = BeanDefinitionBuilder.genericBeanDefinition(GatewayMethodMetadata.class);
                methodMetadataBuilder.addPropertyValue("requestChannelName", (Object)methodElement.getAttribute("request-channel"));
                methodMetadataBuilder.addPropertyValue("replyChannelName", (Object)methodElement.getAttribute("reply-channel"));
                methodMetadataBuilder.addPropertyValue("requestTimeout", (Object)methodElement.getAttribute("request-timeout"));
                methodMetadataBuilder.addPropertyValue("replyTimeout", (Object)methodElement.getAttribute("reply-timeout"));
                boolean hasMapper = StringUtils.hasText((String)element.getAttribute(MAPPER_ATTR));
                String payloadExpression = methodElement.getAttribute("payload-expression");
                Assert.state((!hasMapper || !StringUtils.hasText((String)payloadExpression) ? 1 : 0) != 0, (String)"'payload-expression' is not allowed when a 'mapper' is provided");
                if (StringUtils.hasText((String)payloadExpression)) {
                    methodMetadataBuilder.addPropertyValue("payloadExpression", (Object)BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class).addConstructorArgValue((Object)payloadExpression).getBeanDefinition());
                }
                if (!CollectionUtils.isEmpty((Collection)(invocationHeaders = DomUtils.getChildElementsByTagName((Element)methodElement, (String)"header")))) {
                    Assert.state((!hasMapper ? 1 : 0) != 0, (String)"header elements are not allowed when a 'mapper' is provided");
                    ManagedMap headerExpressions = new ManagedMap();
                    for (Element headerElement : invocationHeaders) {
                        BeanDefinition expressionDef = IntegrationNamespaceUtils.createExpressionDefinitionFromValueOrExpression("value", "expression", parserContext, headerElement, true);
                        headerExpressions.put(headerElement.getAttribute("name"), expressionDef);
                    }
                    methodMetadataBuilder.addPropertyValue("headerExpressions", (Object)headerExpressions);
                }
                methodMetadataMap.put(methodName, methodMetadataBuilder.getBeanDefinition());
            }
            gatewayAttributes.put("methods", methodMetadataMap);
        }
    }

    private static BeanDefinitionHolder buildBeanDefinition(Map<String, Object> gatewayAttributes, ParserContext parserContext) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        String defaultPayloadExpression = (String)gatewayAttributes.get("defaultPayloadExpression");
        Object[] defaultHeaders = (Map[])gatewayAttributes.get("defaultHeaders");
        String defaultRequestChannel = (String)gatewayAttributes.get("defaultRequestChannel");
        String defaultReplyChannel = (String)gatewayAttributes.get("defaultReplyChannel");
        String errorChannel = (String)gatewayAttributes.get("errorChannel");
        String asyncExecutor = (String)gatewayAttributes.get(ASYNC_EXECUTOR_ATTR);
        String mapper = (String)gatewayAttributes.get(MAPPER_ATTR);
        String proxyDefaultMethods = (String)gatewayAttributes.get(PROXY_DEFAULT_METHODS_ATTR);
        boolean hasMapper = StringUtils.hasText((String)mapper);
        boolean hasDefaultPayloadExpression = StringUtils.hasText((String)defaultPayloadExpression);
        Assert.state((!hasMapper || !hasDefaultPayloadExpression ? 1 : 0) != 0, (String)"'defaultPayloadExpression' is not allowed when a 'mapper' is provided");
        boolean hasDefaultHeaders = !ObjectUtils.isEmpty((Object[])defaultHeaders);
        Assert.state((!hasMapper || !hasDefaultHeaders ? 1 : 0) != 0, (String)"'defaultHeaders' are not allowed when a 'mapper' is provided");
        ConfigurableBeanFactory beanFactory = GatewayParser.obtainBeanFactory(registry);
        Class<?> serviceInterface = GatewayParser.getServiceInterface((String)gatewayAttributes.get("serviceInterface"), beanFactory);
        BeanDefinitionBuilder gatewayProxyBuilder = BeanDefinitionBuilder.rootBeanDefinition(GatewayProxyFactoryBean.class).addConstructorArgValue(serviceInterface);
        if (hasDefaultHeaders || hasDefaultPayloadExpression) {
            BeanDefinition methodMetadata = GatewayParser.getMethodMetadataBeanDefinition(defaultPayloadExpression, defaultHeaders);
            gatewayProxyBuilder.addPropertyValue("globalMethodMetadata", (Object)methodMetadata);
        }
        if (StringUtils.hasText((String)defaultRequestChannel)) {
            gatewayProxyBuilder.addPropertyValue("defaultRequestChannelName", (Object)defaultRequestChannel);
        }
        if (StringUtils.hasText((String)defaultReplyChannel)) {
            gatewayProxyBuilder.addPropertyValue("defaultReplyChannelName", (Object)defaultReplyChannel);
        }
        if (StringUtils.hasText((String)errorChannel)) {
            gatewayProxyBuilder.addPropertyValue("errorChannelName", (Object)errorChannel);
        }
        if (asyncExecutor == null || "__NULL__".equals(asyncExecutor)) {
            gatewayProxyBuilder.addPropertyValue(ASYNC_EXECUTOR_ATTR, null);
        } else if (StringUtils.hasText((String)asyncExecutor)) {
            gatewayProxyBuilder.addPropertyReference(ASYNC_EXECUTOR_ATTR, asyncExecutor);
        }
        if (StringUtils.hasText((String)mapper)) {
            gatewayProxyBuilder.addPropertyReference(MAPPER_ATTR, mapper);
        }
        if (StringUtils.hasText((String)proxyDefaultMethods)) {
            gatewayProxyBuilder.addPropertyValue(PROXY_DEFAULT_METHODS_ATTR, (Object)proxyDefaultMethods);
        }
        gatewayProxyBuilder.addPropertyValue("defaultRequestTimeoutExpressionString", gatewayAttributes.get("defaultRequestTimeout"));
        gatewayProxyBuilder.addPropertyValue("defaultReplyTimeoutExpressionString", gatewayAttributes.get("defaultReplyTimeout"));
        gatewayProxyBuilder.addPropertyValue("methodMetadataMap", gatewayAttributes.get("methods"));
        String id = (String)gatewayAttributes.get("name");
        if (!StringUtils.hasText((String)id)) {
            BeanNameGenerator beanNameGenerator = IntegrationConfigUtils.annotationBeanNameGenerator(registry);
            id = beanNameGenerator.generateBeanName((BeanDefinition)new AnnotatedGenericBeanDefinition(serviceInterface), registry);
        }
        RootBeanDefinition beanDefinition = (RootBeanDefinition)gatewayProxyBuilder.getBeanDefinition();
        beanDefinition.setTargetType(ResolvableType.forClassWithGenerics(GatewayProxyFactoryBean.class, (Class[])new Class[]{serviceInterface}));
        return new BeanDefinitionHolder((BeanDefinition)beanDefinition, id);
    }

    private static BeanDefinition getMethodMetadataBeanDefinition(String defaultPayloadExpression, Map<String, Object>[] defaultHeaders) {
        BeanDefinitionBuilder methodMetadataBuilder = BeanDefinitionBuilder.genericBeanDefinition(GatewayMethodMetadata.class);
        if (StringUtils.hasText((String)defaultPayloadExpression)) {
            methodMetadataBuilder.addPropertyValue("payloadExpression", (Object)BeanDefinitionBuilder.genericBeanDefinition(ExpressionFactoryBean.class).addConstructorArgValue((Object)defaultPayloadExpression).getBeanDefinition());
        }
        if (!ObjectUtils.isEmpty((Object[])defaultHeaders)) {
            ManagedMap headerExpressions = new ManagedMap();
            for (Map<String, Object> header : defaultHeaders) {
                String headerValue = (String)header.get("value");
                String headerExpression = (String)header.get("expression");
                boolean hasValue = StringUtils.hasText((String)headerValue);
                if (hasValue == StringUtils.hasText((String)headerExpression)) {
                    throw new BeanDefinitionStoreException("exactly one of 'value' or 'expression' is required on a gateway's header.");
                }
                RootBeanDefinition expressionDef = new RootBeanDefinition(hasValue ? LiteralExpression.class : ExpressionFactoryBean.class);
                expressionDef.getConstructorArgumentValues().addGenericArgumentValue((Object)(hasValue ? headerValue : headerExpression));
                headerExpressions.put((String)header.get("name"), expressionDef);
            }
            methodMetadataBuilder.addPropertyValue("headerExpressions", (Object)headerExpressions);
        }
        return methodMetadataBuilder.getBeanDefinition();
    }

    private static ConfigurableBeanFactory obtainBeanFactory(BeanDefinitionRegistry registry) {
        if (registry instanceof ConfigurableBeanFactory) {
            return (ConfigurableBeanFactory)registry;
        }
        if (registry instanceof ConfigurableApplicationContext) {
            return ((ConfigurableApplicationContext)registry).getBeanFactory();
        }
        throw new IllegalArgumentException("The provided 'BeanDefinitionRegistry' must be an instance of 'ConfigurableBeanFactory' or 'ConfigurableApplicationContext', but given is: " + registry.getClass());
    }

    private static Class<?> getServiceInterface(String serviceInterface, ConfigurableBeanFactory beanFactory) {
        String actualServiceInterface = beanFactory.resolveEmbeddedValue(serviceInterface);
        if (!StringUtils.hasText((String)actualServiceInterface)) {
            return RequestReplyExchanger.class;
        }
        try {
            return ClassUtils.forName((String)actualServiceInterface, (ClassLoader)beanFactory.getBeanClassLoader());
        }
        catch (ClassNotFoundException ex) {
            throw new BeanDefinitionStoreException("Cannot parse class for service interface", (Throwable)ex);
        }
    }
}

