/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConversionServiceFactory;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.integration.json.JsonNodeWrapperToJsonNodeConverter;
import org.springframework.integration.support.json.JacksonPresent;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.util.Assert;

class ConverterRegistrar
implements InitializingBean,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    ConverterRegistrar() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() {
        ConversionService conversionService = IntegrationUtils.getConversionService((BeanFactory)this.applicationContext);
        if (conversionService instanceof GenericConversionService) {
            this.registerConverters((GenericConversionService)conversionService);
        } else {
            Assert.notNull((Object)conversionService, () -> "Failed to locate 'integrationConversionService'");
        }
    }

    private void registerConverters(GenericConversionService conversionService) {
        Set converters = this.applicationContext.getBeansOfType(IntegrationConverterRegistration.class).values().stream().map(IntegrationConverterRegistration::converter).collect(Collectors.toSet());
        if (JacksonPresent.isJackson2Present()) {
            converters.add(new JsonNodeWrapperToJsonNodeConverter());
        }
        ConversionServiceFactory.registerConverters(converters, (ConverterRegistry)conversionService);
    }

    record IntegrationConverterRegistration(Object converter) {
    }
}

