/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.registry.consumer;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.servicecomb.foundation.common.cache.VersionedCache;
import org.apache.servicecomb.foundation.common.utils.StringBuilderUtils;
import org.apache.servicecomb.registry.api.registry.Framework;
import org.apache.servicecomb.registry.api.registry.Microservice;
import org.apache.servicecomb.registry.api.registry.MicroserviceInstance;
import org.apache.servicecomb.registry.cache.InstanceCache;
import org.apache.servicecomb.registry.consumer.MicroserviceVersion;
import org.apache.servicecomb.registry.consumer.MicroserviceVersionRuleData;
import org.apache.servicecomb.registry.version.VersionRule;
import org.apache.servicecomb.registry.version.VersionRuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicroserviceVersionRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroserviceVersionRule.class);
    private final String appId;
    private final String microserviceName;
    private final VersionRule versionRule;
    private MicroserviceVersionRuleData data;

    public MicroserviceVersionRule(String appId, String microserviceName, String strVersionRule) {
        this.appId = appId;
        this.microserviceName = microserviceName;
        this.versionRule = VersionRuleUtils.getOrCreate(strVersionRule);
        this.data = this.createEmptyData();
    }

    public String getAppId() {
        return this.appId;
    }

    public String getMicroserviceName() {
        return this.microserviceName;
    }

    public VersionRule getVersionRule() {
        return this.versionRule;
    }

    public <T extends MicroserviceVersion> T getLatestMicroserviceVersion() {
        return this.data.getLatestMicroserviceVersion();
    }

    public Map<String, MicroserviceInstance> getInstances() {
        return this.data.instances;
    }

    public InstanceCache getInstanceCache() {
        return this.data.instanceCache;
    }

    public VersionedCache getVersionedCache() {
        return this.data.versionedCache;
    }

    public MicroserviceVersionRuleData getData() {
        return this.data;
    }

    public void update(Map<String, MicroserviceVersion> allVersions, Collection<MicroserviceInstance> allInstances) {
        if (allInstances == null) {
            allInstances = Collections.emptyList();
        }
        this.data = "latest".equals(this.versionRule.getVersionRule()) ? this.createDataByLatestRule(allVersions, allInstances) : this.createDataByOtherRule(allVersions, allInstances);
        this.printData(this.data, allVersions.size(), allInstances.size());
    }

    private void printData(MicroserviceVersionRuleData data, int inputVersionCount, int inputInstanceCount) {
        String latestVersion;
        String string = latestVersion = data.latestVersion == null ? null : data.latestVersion.getVersion().getVersion();
        if (data.getInstances().isEmpty()) {
            LOGGER.info("update instances to be empty caused by version rule, appId={}, microserviceName={}, versionRule={}, latestVersion={}, inputVersionCount={}, inputInstanceCount={}", new Object[]{this.appId, this.microserviceName, this.versionRule.getVersionRule(), latestVersion, inputVersionCount, inputInstanceCount});
            return;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilderUtils.appendLine((StringBuilder)sb, (String)"update instances, appId=%s, microserviceName=%s, versionRule=%s, latestVersion=%s, inputVersionCount=%s, inputInstanceCount=%s", (Object[])new Object[]{this.appId, this.microserviceName, this.versionRule.getVersionRule(), latestVersion, inputVersionCount, inputInstanceCount});
        int idx = 0;
        for (MicroserviceInstance instance : data.getInstances().values()) {
            MicroserviceVersion microserviceVersion = data.versions.get(instance.getServiceId());
            Microservice microservice = microserviceVersion.getMicroservice();
            Framework framework = microservice.getFramework();
            String frameworkName = framework == null ? "unknown" : framework.getName();
            String frameworkVersion = framework == null ? "unknown" : framework.getVersion();
            StringBuilderUtils.appendLine((StringBuilder)sb, (String)"  %d.instanceId=%s, status=%s, version=%s, endpoints=%s, environment=%s, framework.name=%s, framework.version=%s", (Object[])new Object[]{idx, instance.getInstanceId(), instance.getStatus(), microserviceVersion.getVersion(), instance.getEndpoints(), microservice.getEnvironment(), frameworkName, frameworkVersion});
            ++idx;
        }
        LOGGER.info(StringBuilderUtils.deleteLast((StringBuilder)sb, (int)1).toString());
    }

    private void initData(MicroserviceVersionRuleData data) {
        if (data.latestVersion == null) {
            data.latestVersion = this.findLatest(data.versions, data.instances.values());
        }
        data.instanceCache = new InstanceCache(this.appId, this.microserviceName, this.versionRule.getVersionRule(), data.instances);
        data.versionedCache = new VersionedCache().name(this.versionRule.getVersionRule()).autoCacheVersion().data(data.instances);
    }

    private MicroserviceVersionRuleData createEmptyData() {
        MicroserviceVersionRuleData data = new MicroserviceVersionRuleData();
        data.versions = Collections.emptyMap();
        data.instances = Collections.emptyMap();
        this.initData(data);
        return data;
    }

    private MicroserviceVersion findLatest(Map<String, MicroserviceVersion> allVersions, Collection<MicroserviceInstance> allInstances) {
        if (allInstances.isEmpty()) {
            return allVersions.isEmpty() ? null : allVersions.values().stream().max(Comparator.comparing(MicroserviceVersion::getVersion)).get();
        }
        MicroserviceVersion latestVersion = null;
        for (MicroserviceInstance instance : allInstances) {
            MicroserviceVersion version = allVersions.get(instance.getServiceId());
            if (latestVersion != null && latestVersion.version.compareTo(version.version) >= 0) continue;
            latestVersion = version;
        }
        return latestVersion;
    }

    private MicroserviceVersionRuleData createDataByLatestRule(Map<String, MicroserviceVersion> allVersions, Collection<MicroserviceInstance> allInstances) {
        MicroserviceVersion latestVersion = this.findLatest(allVersions, allInstances);
        if (latestVersion == null) {
            return this.createEmptyData();
        }
        MicroserviceVersionRuleData data = new MicroserviceVersionRuleData();
        String serviceId = latestVersion.getMicroservice().getServiceId();
        data.latestVersion = latestVersion;
        data.versions = Collections.singletonMap(serviceId, latestVersion);
        data.instances = allInstances.stream().filter(instance -> instance.getServiceId().equals(serviceId)).collect(Collectors.toMap(MicroserviceInstance::getInstanceId, Function.identity()));
        data.instances = Collections.unmodifiableMap(data.instances);
        this.initData(data);
        return data;
    }

    private MicroserviceVersionRuleData createDataByOtherRule(Map<String, MicroserviceVersion> allVersions, Collection<MicroserviceInstance> allInstances) {
        MicroserviceVersionRuleData data = new MicroserviceVersionRuleData();
        data.versions = allVersions.values().stream().filter(v -> this.versionRule.isAccept(v.version)).collect(Collectors.toMap(MicroserviceVersion::getMicroserviceId, Function.identity()));
        data.versions = Collections.unmodifiableMap(data.versions);
        if (data.versions.isEmpty()) {
            return this.createEmptyData();
        }
        data.instances = allInstances.stream().filter(instance -> data.versions.containsKey(instance.getServiceId())).collect(Collectors.toMap(MicroserviceInstance::getInstanceId, Function.identity()));
        data.instances = Collections.unmodifiableMap(data.instances);
        this.initData(data);
        return data;
    }
}

