/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.attribute;

import org.apache.rocketmq.common.attribute.Attribute;

public class LongRangeAttribute
extends Attribute {
    private final long min;
    private final long max;
    private final long defaultValue;

    public LongRangeAttribute(String name, boolean changeable, long min, long max, long defaultValue) {
        super(name, changeable);
        this.min = min;
        this.max = max;
        this.defaultValue = defaultValue;
    }

    @Override
    public void verify(String value) {
        long l = Long.parseLong(value);
        if (l < this.min || l > this.max) {
            throw new RuntimeException(String.format("value is not in range(%d, %d)", this.min, this.max));
        }
    }

    public long getDefaultValue() {
        return this.defaultValue;
    }
}

