/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.auth;

import jakarta.servlet.http.HttpServletRequest;
import javax.security.auth.Subject;
import org.apache.qpid.server.management.plugin.HttpManagementConfiguration;
import org.apache.qpid.server.management.plugin.HttpManagementUtil;
import org.apache.qpid.server.management.plugin.HttpRequestInteractiveAuthenticator;
import org.apache.qpid.server.management.plugin.auth.SSLClientCertPreemptiveAuthenticator;
import org.apache.qpid.server.model.AuthenticationProvider;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.auth.manager.ExternalAuthenticationManager;

@PluggableService
public class SSLClientCertInteractiveAuthenticator
implements HttpRequestInteractiveAuthenticator {
    private static final HttpRequestInteractiveAuthenticator.LogoutHandler LOGOUT_HANDLER = response -> response.sendRedirect("/logout.html");
    private final SSLClientCertPreemptiveAuthenticator _preemptiveAuthenticator = new SSLClientCertPreemptiveAuthenticator();

    @Override
    public HttpRequestInteractiveAuthenticator.AuthenticationHandler getAuthenticationHandler(HttpServletRequest request, HttpManagementConfiguration configuration) {
        AuthenticationProvider authenticationProvider = configuration.getAuthenticationProvider(request);
        if (authenticationProvider instanceof ExternalAuthenticationManager) {
            return response -> {
                Subject subject = this._preemptiveAuthenticator.attemptAuthentication(request, configuration);
                if (subject != null) {
                    Broker broker = (Broker)authenticationProvider.getParent();
                    HttpManagementUtil.createServletConnectionSubjectAssertManagementAccessAndSave(broker, request, subject);
                    response.sendRedirect("/");
                } else {
                    response.sendError(401);
                }
            };
        }
        return null;
    }

    @Override
    public HttpRequestInteractiveAuthenticator.LogoutHandler getLogoutHandler(HttpServletRequest request, HttpManagementConfiguration configuration) {
        return LOGOUT_HANDLER;
    }

    public String getType() {
        return "SSLClientAuth";
    }
}

