/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.framing;

import java.util.ArrayList;
import java.util.Formatter;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.ConnectionHandler;
import org.apache.qpid.server.protocol.v1_0.codec.ProtocolHandler;
import org.apache.qpid.server.protocol.v1_0.codec.ValueHandler;
import org.apache.qpid.server.protocol.v1_0.type.AmqpErrorException;
import org.apache.qpid.server.protocol.v1_0.type.ErrorCondition;
import org.apache.qpid.server.protocol.v1_0.type.transport.AmqpError;
import org.apache.qpid.server.protocol.v1_0.type.transport.ChannelFrameBody;
import org.apache.qpid.server.protocol.v1_0.type.transport.ConnectionError;
import org.apache.qpid.server.protocol.v1_0.type.transport.Error;
import org.apache.qpid.server.protocol.v1_0.type.transport.Transfer;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameHandler
implements ProtocolHandler {
    public static final Logger LOGGER = LoggerFactory.getLogger(FrameHandler.class);
    private final boolean _isSasl;
    private final ConnectionHandler _connectionHandler;
    private final ValueHandler _valueHandler;
    private boolean _errored = false;

    public FrameHandler(ValueHandler valueHandler, ConnectionHandler connectionHandler, boolean isSasl) {
        this._valueHandler = valueHandler;
        this._connectionHandler = connectionHandler;
        this._isSasl = isSasl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ProtocolHandler parse(QpidByteBuffer in) {
        try {
            int remaining;
            LOGGER.debug("RECV {} bytes", (Object)in.remaining());
            Error frameParsingError = null;
            ArrayList<ChannelFrameBody> channelFrameBodies = new ArrayList<ChannelFrameBody>();
            while ((remaining = in.remaining()) >= 8 && frameParsingError == null) {
                int size = in.getInt();
                if (size < 8) {
                    frameParsingError = this.createFramingError("specified frame size %d smaller than minimum frame header size %d", size, 8);
                    break;
                }
                if (size > this._connectionHandler.getMaxFrameSize()) {
                    frameParsingError = this.createFramingError("specified frame size %d larger than maximum frame header size %d", size, this._connectionHandler.getMaxFrameSize());
                    break;
                }
                if (remaining < size) {
                    in.position(in.position() - 4);
                    break;
                }
                int dataOffset = in.get() << 2 & 0x3FF;
                if (dataOffset < 8) {
                    frameParsingError = this.createFramingError("specified frame data offset %d smaller than minimum frame header size %d", dataOffset, 8);
                    break;
                }
                if (dataOffset > size) {
                    frameParsingError = this.createFramingError("specified frame data offset %d larger than the frame size %d", dataOffset, size);
                    break;
                }
                byte type = in.get();
                switch (type) {
                    case 0: {
                        if (!this._isSasl) break;
                        frameParsingError = this.createFramingError("received an AMQP frame type when expecting an SASL frame", new Object[0]);
                        break;
                    }
                    case 1: {
                        if (this._isSasl) break;
                        frameParsingError = this.createFramingError("received a SASL frame type when expecting an AMQP frame", new Object[0]);
                        break;
                    }
                    default: {
                        frameParsingError = this.createFramingError("unknown frame type: %d", type);
                    }
                }
                if (frameParsingError != null) break;
                final int channel = in.getUnsignedShort();
                if (dataOffset != 8) {
                    in.position(in.position() + dataOffset - 8);
                }
                try {
                    QpidByteBuffer dup = in.slice();
                    try {
                        Object frameBody;
                        dup.limit(size - dataOffset);
                        in.position(in.position() + size - dataOffset);
                        boolean hasFrameBody = dup.hasRemaining();
                        if (hasFrameBody) {
                            frameBody = this._valueHandler.parse(dup);
                            if (dup.hasRemaining()) {
                                if (frameBody instanceof Transfer) {
                                    try (QpidByteBuffer payload = dup.slice();){
                                        ((Transfer)frameBody).setPayload(payload);
                                    }
                                } else {
                                    frameParsingError = this.createFramingError("Frame length %d larger than contained frame body %s.", size, frameBody);
                                    break;
                                }
                            }
                        } else {
                            frameBody = null;
                            if (this._isSasl) {
                                frameParsingError = this.createFramingError("Empty (heartbeat) frames are not permitted during SASL negotiation", new Object[0]);
                                break;
                            }
                        }
                        channelFrameBodies.add(new ChannelFrameBody(){

                            @Override
                            public int getChannel() {
                                return channel;
                            }

                            @Override
                            public Object getFrameBody() {
                                return frameBody;
                            }
                        });
                        if (!this._isSasl) continue;
                        break;
                    }
                    finally {
                        if (dup == null) continue;
                        dup.close();
                    }
                }
                catch (AmqpErrorException ex) {
                    frameParsingError = ex.getError();
                }
            }
            if (frameParsingError != null) {
                this._connectionHandler.handleError(frameParsingError);
                this._errored = true;
                return this;
            }
            this._connectionHandler.receive(channelFrameBodies);
            return this;
        }
        catch (RuntimeException e) {
            if (e instanceof ServerScopedRuntimeException) {
                throw e;
            }
            LOGGER.warn("Unexpected exception handling frame", (Throwable)e);
            this._connectionHandler.handleError(this.createError(AmqpError.INTERNAL_ERROR, e.toString(), new Object[0]));
        }
        return this;
    }

    private Error createFramingError(String description, Object ... args) {
        return this.createError(ConnectionError.FRAMING_ERROR, description, args);
    }

    private Error createError(ErrorCondition framingError, String description, Object ... args) {
        Error error = new Error();
        error.setCondition(framingError);
        Formatter formatter = new Formatter();
        error.setDescription(formatter.format(description, args).toString());
        return error;
    }

    @Override
    public boolean isDone() {
        return this._errored || this._connectionHandler.closedForInput();
    }
}

