/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.concurrent.ScheduledFuture;
import org.apache.qpid.server.model.VirtualHost;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HouseKeepingTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HouseKeepingTask.class);
    private final String _name;
    private final AccessControlContext _accessControlContext;
    private ScheduledFuture<?> _future;

    public HouseKeepingTask(String name, VirtualHost vhost, AccessControlContext context) {
        this._name = name == null ? vhost.getName() + ":" + this.getClass().getSimpleName() : name;
        this._accessControlContext = context;
    }

    @Override
    public final void run() {
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(this._name);
        try {
            AccessController.doPrivileged(() -> {
                try {
                    this.execute();
                }
                catch (ConnectionScopedRuntimeException e) {
                    LOGGER.warn("Execution of housekeeping task failed", (Throwable)e);
                }
                return null;
            }, this._accessControlContext);
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    public abstract void execute();

    void setFuture(ScheduledFuture<?> future) {
        this._future = future;
    }

    public synchronized void cancel() {
        if (this._future != null) {
            this._future.cancel(false);
            this._future = null;
        }
    }
}

