/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.nio.channels.ScatteringByteChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.bytebuffer.QpidByteBufferFactory;
import org.apache.qpid.server.bytebuffer.QpidByteBufferInputStream;
import org.apache.qpid.server.bytebuffer.SingleQpidByteBuffer;
import org.apache.qpid.server.util.PrimitivesUtils;

class MultiQpidByteBuffer
implements QpidByteBuffer {
    private final SingleQpidByteBuffer[] _fragments;
    private volatile int _resetFragmentIndex = -1;

    private MultiQpidByteBuffer(SingleQpidByteBuffer ... fragments) {
        if (fragments == null) {
            throw new IllegalArgumentException();
        }
        this._fragments = fragments;
    }

    MultiQpidByteBuffer(List<SingleQpidByteBuffer> fragments) {
        if (fragments == null) {
            throw new IllegalArgumentException();
        }
        this._fragments = fragments.toArray(new SingleQpidByteBuffer[fragments.size()]);
    }

    @Override
    public QpidByteBuffer put(int index, byte b) {
        return this.put(index, new byte[]{b});
    }

    @Override
    public QpidByteBuffer putShort(int index, short value) {
        byte[] valueArray = PrimitivesUtils.toByteArray(value);
        return this.put(index, valueArray);
    }

    @Override
    public QpidByteBuffer putChar(int index, char value) {
        byte[] valueArray = PrimitivesUtils.toByteArray(value);
        return this.put(index, valueArray);
    }

    @Override
    public QpidByteBuffer putInt(int index, int value) {
        byte[] valueArray = PrimitivesUtils.toByteArray(value);
        return this.put(index, valueArray);
    }

    @Override
    public QpidByteBuffer putLong(int index, long value) {
        byte[] valueArray = PrimitivesUtils.toByteArray(value);
        return this.put(index, valueArray);
    }

    @Override
    public QpidByteBuffer putFloat(int index, float value) {
        int intValue = Float.floatToRawIntBits(value);
        return this.putInt(index, intValue);
    }

    @Override
    public QpidByteBuffer putDouble(int index, double value) {
        long longValue = Double.doubleToRawLongBits(value);
        return this.putLong(index, longValue);
    }

    private QpidByteBuffer put(int index, byte[] src) {
        int valueWidth = src.length;
        if (index < 0 || index + valueWidth > this.limit()) {
            throw new IndexOutOfBoundsException(String.format("index %d is out of bounds [%d, %d)", index, 0, this.limit()));
        }
        int written = 0;
        int bytesToSkip = index;
        for (int i = 0; i < this._fragments.length && written != valueWidth; ++i) {
            boolean isLastFragmentToConsider;
            SingleQpidByteBuffer buffer = this._fragments[i];
            int limit = buffer.limit();
            boolean bl = isLastFragmentToConsider = valueWidth + bytesToSkip - written <= limit;
            if (!isLastFragmentToConsider && limit != buffer.capacity()) {
                throw new IllegalStateException(String.format("Unexpected limit %d on fragment %d", limit, i));
            }
            if (bytesToSkip >= limit) {
                bytesToSkip -= limit;
                continue;
            }
            int bytesToCopy = Math.min(limit - bytesToSkip, valueWidth - written);
            int originalPosition = buffer.position();
            buffer.position(bytesToSkip);
            buffer.put(src, written, bytesToCopy);
            buffer.position(originalPosition);
            written += bytesToCopy;
            bytesToSkip = 0;
        }
        if (valueWidth != written) {
            throw new BufferOverflowException();
        }
        return this;
    }

    @Override
    public final QpidByteBuffer put(byte b) {
        return this.put(new byte[]{b});
    }

    @Override
    public final QpidByteBuffer putUnsignedByte(short s) {
        this.put((byte)s);
        return this;
    }

    @Override
    public final QpidByteBuffer putShort(short value) {
        byte[] valueArray = PrimitivesUtils.toByteArray(value);
        return this.put(valueArray);
    }

    @Override
    public final QpidByteBuffer putUnsignedShort(int i) {
        this.putShort((short)i);
        return this;
    }

    @Override
    public final QpidByteBuffer putChar(char value) {
        byte[] valueArray = PrimitivesUtils.toByteArray(value);
        return this.put(valueArray);
    }

    @Override
    public final QpidByteBuffer putInt(int value) {
        byte[] valueArray = PrimitivesUtils.toByteArray(value);
        return this.put(valueArray);
    }

    @Override
    public final QpidByteBuffer putUnsignedInt(long value) {
        this.putInt((int)value);
        return this;
    }

    @Override
    public final QpidByteBuffer putLong(long value) {
        byte[] valueArray = PrimitivesUtils.toByteArray(value);
        return this.put(valueArray);
    }

    @Override
    public final QpidByteBuffer putFloat(float value) {
        int intValue = Float.floatToRawIntBits(value);
        return this.putInt(intValue);
    }

    @Override
    public final QpidByteBuffer putDouble(double value) {
        long longValue = Double.doubleToRawLongBits(value);
        return this.putLong(longValue);
    }

    @Override
    public final QpidByteBuffer put(byte[] src) {
        return this.put(src, 0, src.length);
    }

    @Override
    public final QpidByteBuffer put(byte[] src, int offset, int length) {
        int bytesToWrite;
        if (!this.hasRemaining(length)) {
            throw new BufferOverflowException();
        }
        int written = 0;
        for (int i = 0; i < this._fragments.length && written != length; written += bytesToWrite, ++i) {
            SingleQpidByteBuffer buffer = this._fragments[i];
            bytesToWrite = Math.min(buffer.remaining(), length - written);
            buffer.put(src, offset + written, bytesToWrite);
        }
        if (written != length) {
            throw new IllegalStateException(String.format("Unexpectedly only wrote %d of %d bytes.", written, length));
        }
        return this;
    }

    @Override
    public final QpidByteBuffer put(ByteBuffer src) {
        int valueWidth = src.remaining();
        if (!this.hasRemaining(valueWidth)) {
            throw new BufferOverflowException();
        }
        int written = 0;
        for (int i = 0; i < this._fragments.length && written != valueWidth; ++i) {
            SingleQpidByteBuffer dstFragment = this._fragments[i];
            if (!dstFragment.hasRemaining()) continue;
            int srcFragmentRemaining = src.remaining();
            int dstFragmentRemaining = dstFragment.remaining();
            if (dstFragmentRemaining >= srcFragmentRemaining) {
                dstFragment.put(src);
                written += srcFragmentRemaining;
                continue;
            }
            int srcOriginalLimit = src.limit();
            src.limit(src.position() + dstFragmentRemaining);
            dstFragment.put(src);
            src.limit(srcOriginalLimit);
            written += dstFragmentRemaining;
        }
        if (written != valueWidth) {
            throw new IllegalStateException(String.format("Unexpectedly only wrote %d of %d bytes.", written, valueWidth));
        }
        return this;
    }

    @Override
    public final QpidByteBuffer put(QpidByteBuffer qpidByteBuffer) {
        int valueWidth = qpidByteBuffer.remaining();
        if (!this.hasRemaining(valueWidth)) {
            throw new BufferOverflowException();
        }
        int written = 0;
        if (qpidByteBuffer instanceof SingleQpidByteBuffer) {
            SingleQpidByteBuffer srcFragment = (SingleQpidByteBuffer)qpidByteBuffer;
            for (int i = 0; i < this._fragments.length && written != valueWidth; ++i) {
                SingleQpidByteBuffer dstFragment = this._fragments[i];
                if (!dstFragment.hasRemaining()) continue;
                int dstFragmentRemaining = dstFragment.remaining();
                if (dstFragmentRemaining >= valueWidth) {
                    dstFragment.put(srcFragment);
                    written += valueWidth;
                    continue;
                }
                int srcOriginalLimit = srcFragment.limit();
                srcFragment.limit(srcFragment.position() + dstFragmentRemaining);
                dstFragment.put(srcFragment);
                srcFragment.limit(srcOriginalLimit);
                written += dstFragmentRemaining;
            }
        } else if (qpidByteBuffer instanceof MultiQpidByteBuffer) {
            SingleQpidByteBuffer[] fragments = ((MultiQpidByteBuffer)qpidByteBuffer)._fragments;
            int i = 0;
            block1: for (int i1 = 0; i1 < fragments.length; ++i1) {
                SingleQpidByteBuffer srcFragment = fragments[i1];
                while (i < this._fragments.length) {
                    SingleQpidByteBuffer dstFragment = this._fragments[i];
                    if (dstFragment.hasRemaining()) {
                        int srcFragmentRemaining = srcFragment.remaining();
                        int dstFragmentRemaining = dstFragment.remaining();
                        if (dstFragmentRemaining >= srcFragmentRemaining) {
                            dstFragment.put(srcFragment);
                            written += srcFragmentRemaining;
                            continue block1;
                        }
                        int srcOriginalLimit = srcFragment.limit();
                        srcFragment.limit(srcFragment.position() + dstFragmentRemaining);
                        dstFragment.put(srcFragment);
                        srcFragment.limit(srcOriginalLimit);
                        written += dstFragmentRemaining;
                    }
                    ++i;
                }
            }
        } else {
            throw new IllegalStateException("unknown QBB implementation");
        }
        if (written != valueWidth) {
            throw new IllegalStateException(String.format("Unexpectedly only wrote %d of %d bytes.", written, valueWidth));
        }
        return this;
    }

    @Override
    public byte get(int index) {
        byte[] byteArray = this.getByteArray(index, 1);
        return byteArray[0];
    }

    @Override
    public short getShort(int index) {
        byte[] byteArray = this.getByteArray(index, 2);
        return PrimitivesUtils.shortFromByteArray(byteArray);
    }

    @Override
    public final int getUnsignedShort(int index) {
        return this.getShort(index) & 0xFFFF;
    }

    @Override
    public char getChar(int index) {
        byte[] byteArray = this.getByteArray(index, 2);
        return PrimitivesUtils.charFromByteArray(byteArray);
    }

    @Override
    public int getInt(int index) {
        byte[] byteArray = this.getByteArray(index, 4);
        return PrimitivesUtils.intFromByteArray(byteArray);
    }

    @Override
    public long getLong(int index) {
        byte[] byteArray = this.getByteArray(index, 8);
        return PrimitivesUtils.longFromByteArray(byteArray);
    }

    @Override
    public float getFloat(int index) {
        int intValue = this.getInt(index);
        return Float.intBitsToFloat(intValue);
    }

    @Override
    public double getDouble(int index) {
        long longValue = this.getLong(index);
        return Double.longBitsToDouble(longValue);
    }

    private byte[] getByteArray(int index, int length) {
        if (index < 0 || index + length > this.limit()) {
            throw new IndexOutOfBoundsException(String.format("%d bytes at index %d do not fit into bounds [%d, %d)", length, index, 0, this.limit()));
        }
        byte[] value = new byte[length];
        int consumed = 0;
        int bytesToSkip = index;
        for (int i = 0; i < this._fragments.length && consumed != length; ++i) {
            boolean isLastFragmentToConsider;
            SingleQpidByteBuffer buffer = this._fragments[i];
            int limit = buffer.limit();
            boolean bl = isLastFragmentToConsider = length + bytesToSkip - consumed <= limit;
            if (!isLastFragmentToConsider && limit != buffer.capacity()) {
                throw new IllegalStateException(String.format("Unexpectedly limit %d on fragment %d.", limit, i));
            }
            if (bytesToSkip >= limit) {
                bytesToSkip -= limit;
                continue;
            }
            int bytesToCopy = Math.min(limit - bytesToSkip, length - consumed);
            int originalPosition = buffer.position();
            buffer.position(bytesToSkip);
            buffer.get(value, consumed, bytesToCopy);
            buffer.position(originalPosition);
            consumed += bytesToCopy;
            bytesToSkip = 0;
        }
        if (consumed != length) {
            throw new IllegalStateException(String.format("Unexpectedly only consumed %d of %d bytes.", consumed, length));
        }
        return value;
    }

    @Override
    public final byte get() {
        byte[] value = new byte[1];
        this.get(value, 0, 1);
        return value[0];
    }

    @Override
    public final short getUnsignedByte() {
        return (short)(this.get() & 0xFF);
    }

    @Override
    public final short getShort() {
        byte[] value = new byte[2];
        this.get(value, 0, value.length);
        return PrimitivesUtils.shortFromByteArray(value);
    }

    @Override
    public final int getUnsignedShort() {
        return this.getShort() & 0xFFFF;
    }

    @Override
    public final char getChar() {
        byte[] value = new byte[2];
        this.get(value, 0, value.length);
        return PrimitivesUtils.charFromByteArray(value);
    }

    @Override
    public final int getInt() {
        byte[] value = new byte[4];
        this.get(value, 0, value.length);
        return PrimitivesUtils.intFromByteArray(value);
    }

    @Override
    public final long getUnsignedInt() {
        return (long)this.getInt() & 0xFFFFFFFFL;
    }

    @Override
    public final long getLong() {
        byte[] value = new byte[8];
        this.get(value, 0, value.length);
        return PrimitivesUtils.longFromByteArray(value);
    }

    @Override
    public final float getFloat() {
        int intValue = this.getInt();
        return Float.intBitsToFloat(intValue);
    }

    @Override
    public final double getDouble() {
        long longValue = this.getLong();
        return Double.longBitsToDouble(longValue);
    }

    @Override
    public final QpidByteBuffer get(byte[] dst) {
        return this.get(dst, 0, dst.length);
    }

    @Override
    public final QpidByteBuffer get(byte[] dst, int offset, int length) {
        int bytesToCopy;
        if (!this.hasRemaining(length)) {
            throw new BufferUnderflowException();
        }
        int consumed = 0;
        for (int i = 0; i < this._fragments.length && consumed != length; consumed += bytesToCopy, ++i) {
            SingleQpidByteBuffer buffer = this._fragments[i];
            bytesToCopy = Math.min(buffer.remaining(), length - consumed);
            buffer.get(dst, offset + consumed, bytesToCopy);
        }
        if (consumed != length) {
            throw new IllegalStateException(String.format("Unexpectedly only consumed %d of %d bytes.", consumed, length));
        }
        return this;
    }

    @Override
    public final void copyTo(byte[] dst) {
        int remaining = this.remaining();
        if (remaining < dst.length) {
            throw new BufferUnderflowException();
        }
        if (remaining > dst.length) {
            throw new BufferOverflowException();
        }
        int offset = 0;
        for (SingleQpidByteBuffer fragment : this._fragments) {
            int length = Math.min(fragment.remaining(), dst.length - offset);
            fragment.getUnderlyingBuffer().duplicate().get(dst, offset, length);
            offset += length;
        }
    }

    @Override
    public final void copyTo(ByteBuffer dst) {
        if (dst.remaining() < this.remaining()) {
            throw new BufferOverflowException();
        }
        for (SingleQpidByteBuffer fragment : this._fragments) {
            dst.put(fragment.getUnderlyingBuffer().duplicate());
        }
    }

    @Override
    public final void putCopyOf(QpidByteBuffer qpidByteBuffer) {
        int sourceRemaining = qpidByteBuffer.remaining();
        if (!this.hasRemaining(sourceRemaining)) {
            throw new BufferOverflowException();
        }
        if (qpidByteBuffer instanceof MultiQpidByteBuffer) {
            MultiQpidByteBuffer source = (MultiQpidByteBuffer)qpidByteBuffer;
            for (SingleQpidByteBuffer srcFragment : source._fragments) {
                this.put(srcFragment.getUnderlyingBuffer().duplicate());
            }
        } else if (qpidByteBuffer instanceof SingleQpidByteBuffer) {
            SingleQpidByteBuffer source = (SingleQpidByteBuffer)qpidByteBuffer;
            this.put(source.getUnderlyingBuffer().duplicate());
        } else {
            throw new IllegalStateException("unknown QBB implementation");
        }
    }

    @Override
    public final boolean isDirect() {
        for (SingleQpidByteBuffer fragment : this._fragments) {
            if (fragment.isDirect()) continue;
            return false;
        }
        return true;
    }

    @Override
    public final void close() {
        this.dispose();
    }

    @Override
    public final void dispose() {
        for (SingleQpidByteBuffer fragment : this._fragments) {
            fragment.dispose();
        }
    }

    @Override
    public final InputStream asInputStream() {
        return new QpidByteBufferInputStream(this);
    }

    @Override
    public final long read(ScatteringByteChannel channel) throws IOException {
        ByteBuffer[] byteBuffers = new ByteBuffer[this._fragments.length];
        for (int i = 0; i < byteBuffers.length; ++i) {
            SingleQpidByteBuffer fragment = this._fragments[i];
            byteBuffers[i] = fragment.getUnderlyingBuffer();
        }
        return channel.read(byteBuffers);
    }

    public String toString() {
        return "QpidByteBuffer{" + this._fragments.length + " fragments}";
    }

    @Override
    public QpidByteBuffer reset() {
        if (this._resetFragmentIndex < 0) {
            throw new InvalidMarkException();
        }
        SingleQpidByteBuffer fragment = this._fragments[this._resetFragmentIndex];
        fragment.reset();
        int size = this._fragments.length;
        for (int i = this._resetFragmentIndex + 1; i < size; ++i) {
            this._fragments[i].position(0);
        }
        return this;
    }

    @Override
    public QpidByteBuffer rewind() {
        this._resetFragmentIndex = -1;
        for (SingleQpidByteBuffer fragment : this._fragments) {
            fragment.rewind();
        }
        return this;
    }

    @Override
    public final boolean hasArray() {
        return false;
    }

    @Override
    public byte[] array() {
        throw new UnsupportedOperationException("This QpidByteBuffer is not backed by an array.");
    }

    @Override
    public QpidByteBuffer clear() {
        int fragmentsSize = this._fragments.length;
        for (int i = 0; i < fragmentsSize; ++i) {
            this._fragments[i].clear();
        }
        return this;
    }

    @Override
    public QpidByteBuffer compact() {
        int position = this.position();
        int limit = this.limit();
        if (position != 0) {
            int dstPos = 0;
            int srcPos = position;
            while (srcPos < limit) {
                this.put(dstPos, this.get(srcPos));
                ++srcPos;
                ++dstPos;
            }
            this.position(dstPos);
            this.limit(this.capacity());
        }
        this._resetFragmentIndex = -1;
        return this;
    }

    @Override
    public int position() {
        int totalPosition = 0;
        for (SingleQpidByteBuffer fragment : this._fragments) {
            totalPosition += fragment.position();
            if (fragment.position() != fragment.limit()) break;
        }
        return totalPosition;
    }

    @Override
    public QpidByteBuffer position(int newPosition) {
        if (newPosition < 0 || newPosition > this.limit()) {
            throw new IllegalArgumentException(String.format("new position %d is out of bounds [%d, %d)", newPosition, 0, this.limit()));
        }
        int fragmentsSize = this._fragments.length;
        for (int i = 0; i < fragmentsSize; ++i) {
            SingleQpidByteBuffer fragment = this._fragments[i];
            int fragmentLimit = fragment.limit();
            if (newPosition <= fragmentLimit) {
                fragment.position(newPosition);
                newPosition = 0;
                continue;
            }
            if (fragmentLimit != fragment.capacity()) {
                throw new IllegalStateException(String.format("QBB Fragment %d has limit %d != capacity %d", i, fragmentLimit, fragment.capacity()));
            }
            fragment.position(fragmentLimit);
            newPosition -= fragmentLimit;
        }
        return this;
    }

    @Override
    public int limit() {
        int totalLimit = 0;
        for (SingleQpidByteBuffer fragment : this._fragments) {
            int fragmentLimit = fragment.limit();
            totalLimit += fragmentLimit;
            if (fragmentLimit != fragment.capacity()) break;
        }
        return totalLimit;
    }

    @Override
    public QpidByteBuffer limit(int newLimit) {
        for (SingleQpidByteBuffer fragment : this._fragments) {
            int fragmentCapacity = fragment.capacity();
            int fragmentLimit = Math.min(newLimit, fragmentCapacity);
            fragment.limit(fragmentLimit);
            newLimit -= fragmentLimit;
        }
        return this;
    }

    @Override
    public final QpidByteBuffer mark() {
        int fragmentsSize = this._fragments.length;
        for (int i = 0; i < fragmentsSize; ++i) {
            SingleQpidByteBuffer fragment = this._fragments[i];
            if (fragment.position() == fragment.limit()) continue;
            fragment.mark();
            this._resetFragmentIndex = i;
            return this;
        }
        this._resetFragmentIndex = this._fragments.length - 1;
        this._fragments[this._resetFragmentIndex].mark();
        return this;
    }

    @Override
    public final int remaining() {
        int remaining = 0;
        for (SingleQpidByteBuffer fragment : this._fragments) {
            remaining += fragment.remaining();
        }
        return remaining;
    }

    @Override
    public final boolean hasRemaining() {
        return this.hasRemaining(1);
    }

    @Override
    public final boolean hasRemaining(int atLeast) {
        if (atLeast == 0) {
            return true;
        }
        int remaining = 0;
        for (SingleQpidByteBuffer fragment : this._fragments) {
            if ((remaining += fragment.remaining()) < atLeast) continue;
            return true;
        }
        return false;
    }

    @Override
    public QpidByteBuffer flip() {
        for (SingleQpidByteBuffer fragment : this._fragments) {
            fragment.flip();
        }
        return this;
    }

    @Override
    public int capacity() {
        int totalCapacity = 0;
        int fragmentsSize = this._fragments.length;
        for (int i = 0; i < fragmentsSize; ++i) {
            totalCapacity += this._fragments[i].capacity();
        }
        return totalCapacity;
    }

    @Override
    public QpidByteBuffer duplicate() {
        SingleQpidByteBuffer[] fragments = new SingleQpidByteBuffer[this._fragments.length];
        int fragmentsSize = this._fragments.length;
        for (int i = 0; i < fragmentsSize; ++i) {
            fragments[i] = this._fragments[i].duplicate();
        }
        MultiQpidByteBuffer duplicate = new MultiQpidByteBuffer(fragments);
        duplicate._resetFragmentIndex = this._resetFragmentIndex;
        return duplicate;
    }

    @Override
    public QpidByteBuffer slice() {
        return this.view(0, this.remaining());
    }

    @Override
    public QpidByteBuffer view(int offset, int length) {
        if (offset + length > this.remaining()) {
            throw new IllegalArgumentException(String.format("offset: %d, length: %d, remaining: %d", offset, length, this.remaining()));
        }
        ArrayList<SingleQpidByteBuffer> fragments = new ArrayList<SingleQpidByteBuffer>(this._fragments.length);
        boolean firstFragmentToBeConsidered = true;
        int fragmentsSize = this._fragments.length;
        for (int i = 0; i < fragmentsSize && length > 0; ++i) {
            SingleQpidByteBuffer fragment = this._fragments[i];
            if (!fragment.hasRemaining()) continue;
            if (!firstFragmentToBeConsidered && fragment.position() != 0) {
                throw new IllegalStateException(String.format("Unexpectedly position %d on fragment %d.", fragment.position(), i));
            }
            firstFragmentToBeConsidered = false;
            int fragmentRemaining = fragment.remaining();
            if (fragmentRemaining > offset) {
                int fragmentViewLength = Math.min(fragmentRemaining - offset, length);
                fragments.add(fragment.view(offset, fragmentViewLength));
                length -= fragmentViewLength;
                offset = 0;
                continue;
            }
            offset -= fragmentRemaining;
        }
        return QpidByteBufferFactory.createQpidByteBuffer(fragments);
    }

    @Override
    public boolean isSparse() {
        for (SingleQpidByteBuffer fragment : this._fragments) {
            if (!fragment.isSparse()) continue;
            return true;
        }
        return false;
    }

    SingleQpidByteBuffer[] getFragments() {
        return this._fragments;
    }

    ByteBuffer[] getUnderlyingBuffers() {
        ByteBuffer[] byteBuffers = new ByteBuffer[this._fragments.length];
        for (int i = 0; i < this._fragments.length; ++i) {
            byteBuffers[i] = this._fragments[i].getUnderlyingBuffer();
        }
        return byteBuffers;
    }
}

