/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.rolling.FixedWindowRollingPolicy;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.RollingPolicyBase;
import ch.qos.logback.core.rolling.SizeAndTimeBasedFNATP;
import ch.qos.logback.core.rolling.SizeBasedTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedFileNamingAndTriggeringPolicy;
import ch.qos.logback.core.rolling.TimeBasedRollingPolicy;
import ch.qos.logback.core.rolling.TriggeringPolicy;
import ch.qos.logback.core.util.FileSize;
import java.io.File;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.logging.logback.FileLoggerSettings;
import org.apache.qpid.server.logging.logback.RollingPolicyDecorator;

public class AppenderUtils {
    public static void configureRollingFileAppender(FileLoggerSettings fileLoggerSettings, Context loggerContext, RollingFileAppender<ILoggingEvent> appender) {
        Object triggeringPolicy;
        SimpleRollingPolicy rollingPolicy;
        String fileName = fileLoggerSettings.getFileName();
        File file = new File(fileName);
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        AppenderUtils.validateLogFilePermissions(file);
        AppenderUtils.validateMaxFileSize(fileLoggerSettings.getMaxFileSize());
        appender.setFile(fileName);
        appender.setAppend(true);
        appender.setContext(loggerContext);
        String maxFileSizeAsString = String.valueOf(fileLoggerSettings.getMaxFileSize()) + "MB";
        if (fileLoggerSettings.isRollDaily()) {
            DailyTriggeringPolicy dailyTriggeringPolicy = new DailyTriggeringPolicy(fileLoggerSettings.isRollOnRestart(), maxFileSizeAsString);
            dailyTriggeringPolicy.setContext(loggerContext);
            TimeBasedRollingPolicy timeBasedRollingPolicy = new TimeBasedRollingPolicy();
            timeBasedRollingPolicy.setMaxHistory(fileLoggerSettings.getMaxHistory());
            timeBasedRollingPolicy.setTimeBasedFileNamingAndTriggeringPolicy((TimeBasedFileNamingAndTriggeringPolicy)dailyTriggeringPolicy);
            timeBasedRollingPolicy.setFileNamePattern(fileName + ".%d{yyyy-MM-dd}.%i" + (fileLoggerSettings.isCompressOldFiles() ? ".gz" : ""));
            rollingPolicy = timeBasedRollingPolicy;
            triggeringPolicy = dailyTriggeringPolicy;
        } else {
            SizeTriggeringPolicy sizeTriggeringPolicy = new SizeTriggeringPolicy(fileLoggerSettings.isRollOnRestart(), maxFileSizeAsString);
            sizeTriggeringPolicy.setContext(loggerContext);
            SimpleRollingPolicy simpleRollingPolicy = new SimpleRollingPolicy(fileLoggerSettings.getMaxHistory());
            simpleRollingPolicy.setFileNamePattern(fileName + ".%i" + (fileLoggerSettings.isCompressOldFiles() ? ".gz" : ""));
            rollingPolicy = simpleRollingPolicy;
            triggeringPolicy = sizeTriggeringPolicy;
        }
        rollingPolicy.setContext(loggerContext);
        RollingPolicyDecorator decorator = new RollingPolicyDecorator((RollingPolicyBase)rollingPolicy, fileLoggerSettings.getRolloverListener(), fileLoggerSettings.getExecutorService());
        decorator.setParent((FileAppender)appender);
        appender.setRollingPolicy((RollingPolicy)decorator);
        appender.setTriggeringPolicy((TriggeringPolicy)triggeringPolicy);
        decorator.start();
        triggeringPolicy.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setPattern(fileLoggerSettings.getLayout());
        encoder.setContext(loggerContext);
        encoder.start();
        appender.setEncoder((Encoder)encoder);
    }

    static void validateLogFilePermissions(File file) {
        if (file.exists() && (!file.isFile() || !file.canWrite()) || !file.getAbsoluteFile().getParentFile().canWrite()) {
            throw new IllegalConfigurationException(String.format("Do not have the permissions to log to file '%s'.", file.getAbsolutePath()));
        }
    }

    static void validateMaxFileSize(int maxFileSize) {
        if (maxFileSize < 1) {
            throw new IllegalConfigurationException(String.format("Maximum file size must be at least 1. Cannot set to %d.", maxFileSize));
        }
    }

    static class DailyTriggeringPolicy
    extends SizeAndTimeBasedFNATP<ILoggingEvent> {
        private final boolean _rollOnRestart;
        private final FileSize _maxFileSize;
        private volatile boolean _isFirst = true;
        private long _nextCheck;

        public DailyTriggeringPolicy(boolean isRollOnRestart, String maxFileSize) {
            this._rollOnRestart = isRollOnRestart;
            this._maxFileSize = FileSize.valueOf((String)maxFileSize);
            this.setMaxFileSize(this._maxFileSize);
        }

        public void start() {
            super.start();
            if (this._rollOnRestart) {
                this._nextCheck = 0L;
            }
        }

        public boolean isTriggeringEvent(File activeFile, ILoggingEvent event) {
            if (this._rollOnRestart && this._isFirst) {
                this._isFirst = false;
                if (activeFile != null && activeFile.exists() && activeFile.length() == 0L) {
                    this._nextCheck = this.computeNextCheck(this._nextCheck);
                    return false;
                }
            }
            return super.isTriggeringEvent(activeFile, (Object)event);
        }

        public FileSize getMaxFileSize() {
            return this._maxFileSize;
        }
    }

    static class SizeTriggeringPolicy
    extends SizeBasedTriggeringPolicy<ILoggingEvent> {
        private final boolean _rollOnRestart;
        private final FileSize _maxFileSize;
        private volatile boolean _isFirst = true;

        public SizeTriggeringPolicy(boolean isRollOnRestart, String maxFileSize) {
            this._rollOnRestart = isRollOnRestart;
            this._maxFileSize = FileSize.valueOf((String)maxFileSize);
            this.setMaxFileSize(this._maxFileSize);
        }

        public boolean isTriggeringEvent(File activeFile, ILoggingEvent event) {
            if (this._rollOnRestart && this._isFirst) {
                this._isFirst = false;
                return activeFile != null && activeFile.exists() && activeFile.length() != 0L;
            }
            return super.isTriggeringEvent(activeFile, (Object)event);
        }

        public FileSize getMaxFileSize() {
            return this._maxFileSize;
        }
    }

    static class SimpleRollingPolicy
    extends FixedWindowRollingPolicy {
        private final int _maxFiles;

        public SimpleRollingPolicy(int maxHistory) {
            this._maxFiles = maxHistory;
            this.setMaxIndex(maxHistory);
            this.setMinIndex(1);
        }

        protected int getMaxWindowSize() {
            return this._maxFiles;
        }
    }
}

