/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.jsontype.impl;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.jsontype.TypeIdResolver;
import tools.jackson.databind.jsontype.impl.TypeSerializerBase;

public class AsExternalTypeSerializer
extends TypeSerializerBase {
    protected final String _typePropertyName;

    public AsExternalTypeSerializer(TypeIdResolver idRes, BeanProperty property, String propName) {
        super(idRes, property);
        this._typePropertyName = propName;
    }

    @Override
    public AsExternalTypeSerializer forProperty(SerializationContext ctxt, BeanProperty prop) {
        return this._property == prop ? this : new AsExternalTypeSerializer(this._idResolver, prop, this._typePropertyName);
    }

    @Override
    public String getPropertyName() {
        return this._typePropertyName;
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return JsonTypeInfo.As.EXTERNAL_PROPERTY;
    }

    protected final void _writeScalarPrefix(Object value, JsonGenerator g) throws JacksonException {
    }

    protected final void _writeObjectPrefix(Object value, JsonGenerator g) throws JacksonException {
        g.writeStartObject();
    }

    protected final void _writeArrayPrefix(Object value, JsonGenerator g) throws JacksonException {
        g.writeStartArray();
    }

    protected final void _writeScalarSuffix(Object value, JsonGenerator g, String typeId) throws JacksonException {
        if (typeId != null) {
            g.writeStringProperty(this._typePropertyName, typeId);
        }
    }

    protected final void _writeObjectSuffix(Object value, JsonGenerator g, String typeId) throws JacksonException {
        g.writeEndObject();
        if (typeId != null) {
            g.writeStringProperty(this._typePropertyName, typeId);
        }
    }

    protected final void _writeArraySuffix(Object value, JsonGenerator g, String typeId) throws JacksonException {
        g.writeEndArray();
        if (typeId != null) {
            g.writeStringProperty(this._typePropertyName, typeId);
        }
    }
}

