/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.exc;

import java.io.Closeable;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.util.ClassUtil;

public class MismatchedInputException
extends DatabindException {
    private static final long serialVersionUID = 3L;
    protected Class<?> _targetType;
    protected JsonToken _currentToken;

    protected MismatchedInputException(JsonParser p, String msg) {
        this(p, msg, (JavaType)null);
    }

    protected MismatchedInputException(JsonParser p, String msg, TokenStreamLocation loc) {
        super((Closeable)p, msg, loc);
        this._currentToken = MismatchedInputException._currentToken(p);
    }

    protected MismatchedInputException(JsonParser p, String msg, Class<?> targetType) {
        super((Closeable)p, msg);
        this._targetType = targetType;
        this._currentToken = MismatchedInputException._currentToken(p);
    }

    protected MismatchedInputException(JsonParser p, String msg, JavaType targetType) {
        super((Closeable)p, msg);
        this._targetType = ClassUtil.rawClass(targetType);
        this._currentToken = MismatchedInputException._currentToken(p);
    }

    protected static JsonToken _currentToken(JsonParser p) {
        return p == null ? null : p.currentToken();
    }

    public static MismatchedInputException from(JsonParser p, JavaType targetType, String msg) {
        return new MismatchedInputException(p, msg, targetType);
    }

    public static MismatchedInputException from(JsonParser p, Class<?> targetType, String msg) {
        return new MismatchedInputException(p, msg, targetType);
    }

    public MismatchedInputException setTargetType(JavaType t) {
        this._targetType = ClassUtil.rawClass(t);
        return this;
    }

    public MismatchedInputException setCurrentToken(JsonToken t) {
        this._currentToken = t;
        return this;
    }

    public Class<?> getTargetType() {
        return this._targetType;
    }

    public JsonToken getCurrentToken() {
        return this._currentToken;
    }
}

