/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.access.config;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public enum Property {
    ROUTING_KEY,
    NAME,
    QUEUE_NAME,
    OWNER,
    TYPE,
    ALTERNATE,
    DURABLE,
    EXCLUSIVE,
    TEMPORARY,
    AUTO_DELETE,
    COMPONENT,
    PACKAGE,
    CLASS,
    FROM_NETWORK,
    FROM_HOSTNAME,
    VIRTUALHOST_NAME,
    METHOD_NAME,
    ATTRIBUTES,
    CREATED_BY,
    CONNECTION_LIMIT,
    CONNECTION_FREQUENCY_LIMIT;

    private static final Set<Property> BOOLEAN_PROPERTIES;
    private static final Map<String, Property> CANONICAL_NAME_TO_PROPERTY;

    public static boolean isBooleanType(Property property) {
        return BOOLEAN_PROPERTIES.contains((Object)property);
    }

    public static Property parse(String text) {
        String propertyName = Property.getCanonicalName(text);
        Property property = CANONICAL_NAME_TO_PROPERTY.get(propertyName);
        if (property == null) {
            throw new IllegalArgumentException("Not a valid property: " + text + " because " + propertyName + " is not in " + String.valueOf(CANONICAL_NAME_TO_PROPERTY.keySet()));
        }
        return property;
    }

    public String getCanonicalName() {
        return Property.getCanonicalName(this.name());
    }

    private static String getCanonicalName(String name) {
        return name.replace("_", "").toLowerCase(Locale.ENGLISH);
    }

    static {
        BOOLEAN_PROPERTIES = EnumSet.of(DURABLE, EXCLUSIVE, TEMPORARY, AUTO_DELETE);
        CANONICAL_NAME_TO_PROPERTY = new HashMap<String, Property>();
        for (Property property : Property.values()) {
            CANONICAL_NAME_TO_PROPERTY.put(property.getCanonicalName(), property);
        }
        CANONICAL_NAME_TO_PROPERTY.put(Property.getCanonicalName("attribute_names"), ATTRIBUTES);
    }
}

