/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.utilint;

public class IntegralLongAvg
extends Number {
    private static final long serialVersionUID = 1L;
    private long numerator;
    private long denominator;
    private long factor = 1L;

    public IntegralLongAvg(long numerator, long denominator, long factor) {
        this.numerator = numerator;
        this.denominator = denominator;
        this.factor = factor;
    }

    public IntegralLongAvg(long numerator, long denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public IntegralLongAvg(IntegralLongAvg val) {
        this.numerator = val.numerator;
        this.denominator = val.denominator;
        this.factor = val.factor;
    }

    public void add(IntegralLongAvg other) {
        this.numerator += other.numerator;
        this.denominator += other.denominator;
    }

    public void subtract(IntegralLongAvg other) {
        this.numerator -= other.numerator;
        this.denominator -= other.denominator;
    }

    public long compute() {
        return this.denominator != 0L ? this.numerator * this.factor / this.denominator : 0L;
    }

    public long getNumerator() {
        return this.numerator;
    }

    public void setNumerator(long numerator) {
        this.numerator = numerator;
    }

    public long getDenominator() {
        return this.denominator;
    }

    public void setDenominator(long denominator) {
        this.denominator = denominator;
    }

    @Override
    public int intValue() {
        return (int)this.compute();
    }

    @Override
    public long longValue() {
        return this.compute();
    }

    @Override
    public float floatValue() {
        return this.compute();
    }

    @Override
    public double doubleValue() {
        return this.compute();
    }
}

