/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.rep;

import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import com.sleepycat.je.rep.impl.RepImpl;
import com.sleepycat.je.rep.impl.RepParams;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;

public class ReplicationMutableConfig
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ALLOW_ARBITER_ACK = "je.rep.allowArbiterAck";
    public static final String DESIGNATED_PRIMARY = "je.rep.designatedPrimary";
    public static final String ELECTABLE_GROUP_SIZE_OVERRIDE = "je.rep.electableGroupSizeOverride";
    public static final String NODE_PRIORITY = "je.rep.node.priority";
    public static final String RUN_LOG_FLUSH_TASK = "je.rep.runLogFlushTask";
    public static final String LOG_FLUSH_TASK_INTERVAL = "je.rep.logFlushTaskInterval";
    public static final String REPLAY_MAX_OPEN_DB_HANDLES = "je.rep.replayMaxOpenDbHandles";
    public static final String HELPER_HOSTS = "je.rep.helperHosts";
    public static final String REPLAY_DB_HANDLE_TIMEOUT = "je.rep.replayOpenHandleTimeout";
    public static final String CATCHUP_MASTER_TIMEOUT = "je.rep.catchupMasterTimeout";
    protected Properties props;
    transient boolean validateParams = true;

    public ReplicationMutableConfig() {
        this.props = new Properties();
    }

    ReplicationMutableConfig(Properties properties, boolean validateParams) throws IllegalArgumentException {
        this.validateParams = validateParams;
        this.validateProperties(properties);
        this.props = new Properties();
        this.props.putAll((Map<?, ?>)properties);
    }

    void fillInEnvironmentGeneratedProps(RepImpl repImpl) {
        this.props.put(RepParams.DESIGNATED_PRIMARY.getName(), Boolean.toString(repImpl.isDesignatedPrimary()));
        this.props.put(RepParams.NODE_PRIORITY.getName(), Integer.toString(this.getNodePriority()));
    }

    public void copyMutablePropsTo(ReplicationMutableConfig toConfig) {
        Properties toProps = toConfig.props;
        Enumeration<?> propNames = this.props.propertyNames();
        while (propNames.hasMoreElements()) {
            String paramName = (String)propNames.nextElement();
            ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(paramName);
            assert (param != null);
            if (!param.isForReplication() || !param.isMutable()) continue;
            String newVal = this.props.getProperty(paramName);
            toProps.setProperty(paramName, newVal);
        }
    }

    public ReplicationMutableConfig setDesignatedPrimary(boolean isPrimary) {
        this.setDesignatedPrimaryVoid(isPrimary);
        return this;
    }

    public void setDesignatedPrimaryVoid(boolean isPrimary) {
        DbConfigManager.setBooleanVal(this.props, RepParams.DESIGNATED_PRIMARY, isPrimary, this.validateParams);
    }

    public boolean getDesignatedPrimary() {
        return DbConfigManager.getBooleanVal(this.props, RepParams.DESIGNATED_PRIMARY);
    }

    public int getElectableGroupSizeOverride() {
        return DbConfigManager.getIntVal(this.props, RepParams.ELECTABLE_GROUP_SIZE_OVERRIDE);
    }

    public ReplicationMutableConfig setElectableGroupSizeOverride(int override) {
        this.setElectableGroupSizeOverrideVoid(override);
        return this;
    }

    public void setElectableGroupSizeOverrideVoid(int override) {
        DbConfigManager.setIntVal(this.props, RepParams.ELECTABLE_GROUP_SIZE_OVERRIDE, override, this.validateParams);
    }

    public int getNodePriority() {
        return DbConfigManager.getIntVal(this.props, RepParams.NODE_PRIORITY);
    }

    public ReplicationMutableConfig setNodePriority(int priority) {
        this.setNodePriorityVoid(priority);
        return this;
    }

    public void setNodePriorityVoid(int priority) {
        DbConfigManager.setIntVal(this.props, RepParams.NODE_PRIORITY, priority, this.validateParams);
    }

    public String getHelperHosts() {
        return DbConfigManager.getVal(this.props, RepParams.HELPER_HOSTS);
    }

    public ReplicationMutableConfig setHelperHosts(String hostsAndPorts) {
        this.setHelperHostsVoid(hostsAndPorts);
        return this;
    }

    public void setHelperHostsVoid(String hostsAndPorts) {
        DbConfigManager.setVal(this.props, RepParams.HELPER_HOSTS, hostsAndPorts, this.validateParams);
    }

    public ReplicationMutableConfig setConfigParam(String paramName, String value) throws IllegalArgumentException {
        DbConfigManager.setConfigParam(this.props, paramName, value, true, this.validateParams, true, true);
        return this;
    }

    public String getConfigParam(String paramName) throws IllegalArgumentException {
        return DbConfigManager.getConfigParam(this.props, paramName);
    }

    void validateProperties(Properties checkProps) throws IllegalArgumentException {
        Enumeration<?> propNames = checkProps.propertyNames();
        while (propNames.hasMoreElements()) {
            String name = (String)propNames.nextElement();
            ConfigParam param = EnvironmentParams.SUPPORTED_PARAMS.get(name);
            if (param == null) {
                throw new IllegalArgumentException(name + " is not a valid JE environment configuration");
            }
            if (!this.validateParams) continue;
            param.validateValue(checkProps.getProperty(name));
        }
    }

    public Properties getProps() {
        return this.props;
    }

    public String toString() {
        return this.props.toString();
    }

    void setOverrideValidateParams(boolean validateParams) {
        this.validateParams = validateParams;
    }

    public boolean getValidateParams() {
        return this.validateParams;
    }

    protected Object clone() throws CloneNotSupportedException {
        ReplicationMutableConfig copy = (ReplicationMutableConfig)super.clone();
        copy.props = (Properties)this.props.clone();
        return copy;
    }

    static {
        ConfigParam configParam = RepParams.GROUP_NAME;
    }
}

