/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.cleaner.BaseUtilizationTracker;
import com.sleepycat.je.cleaner.FileSummary;
import com.sleepycat.je.cleaner.OffsetList;
import com.sleepycat.je.dbi.MemoryBudget;

public class TrackedFileSummary
extends FileSummary {
    private BaseUtilizationTracker tracker;
    private long fileNum;
    private OffsetList obsoleteOffsets;
    private int memSize;
    private boolean trackDetail;
    private boolean allowFlush = true;

    TrackedFileSummary(BaseUtilizationTracker tracker, long fileNum, boolean trackDetail) {
        this.tracker = tracker;
        this.fileNum = fileNum;
        this.trackDetail = trackDetail;
    }

    public boolean getAllowFlush() {
        return this.allowFlush;
    }

    void setAllowFlush(boolean allowFlush) {
        this.allowFlush = allowFlush;
    }

    public long getFileNumber() {
        return this.fileNum;
    }

    int getMemorySize() {
        return this.memSize;
    }

    @Override
    public void reset() {
        assert (this.tracker != null);
        this.obsoleteOffsets = null;
        this.tracker.resetFile(this);
        if (this.memSize > 0) {
            this.updateMemoryBudget(0 - this.memSize);
        }
        super.reset();
    }

    void trackObsolete(long offset, boolean checkDupOffsets) {
        if (!this.trackDetail) {
            return;
        }
        int adjustMem = 0;
        if (this.obsoleteOffsets == null) {
            this.obsoleteOffsets = new OffsetList();
            adjustMem += MemoryBudget.TFS_LIST_INITIAL_OVERHEAD;
        }
        if (this.obsoleteOffsets.add(offset, checkDupOffsets)) {
            adjustMem += MemoryBudget.TFS_LIST_SEGMENT_OVERHEAD;
        }
        if (adjustMem != 0) {
            this.updateMemoryBudget(adjustMem);
        }
    }

    void addTrackedSummary(TrackedFileSummary other) {
        this.add(other);
        this.memSize += other.memSize;
        if (other.obsoleteOffsets != null) {
            if (this.obsoleteOffsets != null) {
                if (this.obsoleteOffsets.merge(other.obsoleteOffsets)) {
                    this.updateMemoryBudget(-MemoryBudget.TFS_LIST_SEGMENT_OVERHEAD);
                }
            } else {
                this.obsoleteOffsets = other.obsoleteOffsets;
            }
        }
    }

    public long[] getObsoleteOffsets() {
        if (this.obsoleteOffsets != null) {
            return this.obsoleteOffsets.toArray();
        }
        return null;
    }

    boolean containsObsoleteOffset(long offset) {
        if (this.obsoleteOffsets != null) {
            return this.obsoleteOffsets.contains(offset);
        }
        return false;
    }

    private void updateMemoryBudget(int delta) {
        assert (this.tracker != null);
        this.memSize += delta;
        this.tracker.env.getMemoryBudget().updateAdminMemoryUsage(delta);
    }

    void close() {
        assert (this.tracker != null);
        this.tracker.env.getMemoryBudget().updateAdminMemoryUsage(0 - this.memSize);
        this.tracker = null;
        this.memSize = 0;
    }
}

