/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.factory;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.parsing.collector.CollectorType;
import org.apache.qpid.server.query.engine.parsing.expression.Expression;

public final class CollectorFactory {
    private CollectorFactory() {
    }

    private static <T> Collector maximizing(Expression<T, ?> sourceExpression) {
        Predicate<Object> notNullPredicate = Objects::nonNull;
        Comparator comparator = Comparator.naturalOrder();
        Collector collector = Collectors.maxBy(comparator);
        collector = CollectorFactory.filtering(notNullPredicate, collector);
        collector = Collectors.mapping(object -> sourceExpression.apply(object), collector);
        return Collectors.collectingAndThen(collector, opt -> ((Optional)opt).orElse(null));
    }

    private static <T> Collector minimizing(Expression<T, ?> sourceExpression) {
        Predicate<Object> notNullPredicate = Objects::nonNull;
        Comparator comparator = Comparator.naturalOrder();
        Collector collector = Collectors.minBy(comparator);
        collector = CollectorFactory.filtering(notNullPredicate, collector);
        collector = Collectors.mapping(object -> sourceExpression.apply(object), collector);
        return Collectors.collectingAndThen(collector, opt -> ((Optional)opt).orElse(null));
    }

    private static <T> Collector counting(Expression<T, ?> sourceExpression) {
        Predicate<Object> notNullPredicate = Objects::nonNull;
        Collector<Object, ?, Long> collector = Collectors.counting();
        collector = CollectorFactory.filtering(notNullPredicate, collector);
        return Collectors.mapping(object -> sourceExpression.apply(object), collector);
    }

    private static <T> Collector summing(Expression<T, ?> sourceExpression) {
        Predicate<Object> notNullPredicate = Objects::nonNull;
        Collector<Object, ?, Double> collector = Collectors.summingDouble(item -> ((Number)item).doubleValue());
        collector = CollectorFactory.filtering(notNullPredicate, collector);
        return Collectors.mapping(object -> sourceExpression.apply(object), collector);
    }

    private static <T, R> Collector averaging(Expression<T, R> sourceExpression) {
        Predicate<Object> notNullPredicate = Objects::nonNull;
        Collector<Object, ?, Double> collector = Collectors.averagingDouble(item -> ((Number)item).doubleValue());
        collector = CollectorFactory.filtering(notNullPredicate, collector);
        return Collectors.mapping(object -> sourceExpression.apply(object), collector);
    }

    private static <T, A, R> Map<CollectorType, Function<Expression<T, R>, Collector<T, A, R>>> map() {
        HashMap<CollectorType, Function<Expression<T, R>, Collector<T, A, R>>> map = new HashMap<CollectorType, Function<Expression<T, R>, Collector<T, A, R>>>();
        map.put(CollectorType.AVERAGING, CollectorFactory::averaging);
        map.put(CollectorType.COUNTING, CollectorFactory::counting);
        map.put(CollectorType.MAXIMIZING, CollectorFactory::maximizing);
        map.put(CollectorType.MINIMIZING, CollectorFactory::minimizing);
        map.put(CollectorType.SUMMING, CollectorFactory::summing);
        return map;
    }

    public static <T, A, R> Function<Expression<T, R>, Collector<T, A, R>> collector(CollectorType collectorType) {
        Objects.requireNonNull(collectorType, "Collector type should be not null");
        return CollectorFactory.map().get((Object)collectorType);
    }

    public static <T, A, R> Collector<T, A, R> filtering(Predicate<? super T> filter, Collector<T, A, R> collector) {
        return Collector.of(collector.supplier(), (accumulator, input) -> {
            if (filter.test(input)) {
                collector.accumulator().accept(accumulator, input);
            }
        }, collector.combiner(), collector.finisher(), new Collector.Characteristics[0]);
    }
}

