/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.accessor;

import java.util.UUID;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;

public class ConfiguredObjectAccessorExpression<T extends ConfiguredObject<?>, R>
extends AbstractExpressionNode<T, R> {
    private final String _property;

    public ConfiguredObjectAccessorExpression(String property) {
        this._property = property;
    }

    @Override
    public R apply(T value) {
        if ("*".equals(this._property)) {
            return (R)value;
        }
        if ("statistics".equals(this._property)) {
            return (R)value.getStatistics();
        }
        if (!value.getAttributeNames().contains(this._property) && !value.getStatistics().containsKey(this._property)) {
            throw QueryEvaluationException.fieldNotFound(this._property);
        }
        if (value.getAttributeNames().contains(this._property)) {
            Object result = value.getAttribute(this._property);
            if (result == null) {
                return (R)result;
            }
            if (result.getClass().equals(UUID.class)) {
                return (R)result.toString();
            }
            if (result.getClass().isEnum()) {
                return (R)result.toString();
            }
            return (R)result;
        }
        return (R)value.getStatistics().get(this._property);
    }
}

