/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import java.math.BigDecimal;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.AMQTypedValue;
import org.apache.qpid.server.protocol.v0_8.FieldTable;

public class FieldArray<T>
extends AbstractCollection<T> {
    private final Collection<T> _underlying;
    private static final Set<Class<?>> SUPPORTED_CLASSES = new HashSet<Class>(Arrays.asList(Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class, String.class, FieldTable.class, Date.class, BigDecimal.class, byte[].class));

    private FieldArray(Collection<T> underlying) {
        this._underlying = underlying;
    }

    @Override
    public Iterator<T> iterator() {
        return this._underlying.iterator();
    }

    @Override
    public int size() {
        return this._underlying.size();
    }

    public int getEncodingSize() {
        int size = 0;
        for (T obj : this) {
            size += AMQTypedValue.toTypedValue(obj).getEncodingSize() + 1;
        }
        return size;
    }

    public static <T> FieldArray<T> asFieldArray(Collection<T> collection) {
        if (collection instanceof FieldArray) {
            return (FieldArray)collection;
        }
        FieldArray.validateCollection(collection);
        return new FieldArray<T>(collection);
    }

    private static <T> void validateCollection(Collection<T> collection) {
        for (T val : collection) {
            if (val == null || SUPPORTED_CLASSES.contains(val.getClass()) || val instanceof Collection || val instanceof Map) continue;
            throw new IllegalArgumentException("Cannot convert an object of type " + val.getClass().getName());
        }
    }

    public void writeToBuffer(QpidByteBuffer buffer) {
        buffer.putInt(this.getEncodingSize());
        for (T obj : this) {
            AMQTypedValue.toTypedValue(obj).writeToBuffer(buffer);
        }
    }

    public static FieldArray<?> readFromBuffer(QpidByteBuffer buffer) {
        ArrayList<Object> result = new ArrayList<Object>();
        int size = buffer.getInt();
        try (QpidByteBuffer slicedBuffer = buffer.view(0, size);){
            buffer.position(buffer.position() + size);
            while (slicedBuffer.hasRemaining()) {
                result.add(AMQTypedValue.readFromBuffer(slicedBuffer).getValue());
            }
        }
        return new FieldArray(result);
    }

    public static void skipFieldArray(QpidByteBuffer buffer) {
        int size = buffer.getInt();
        if (size > 0) {
            buffer.position(buffer.position() + size);
        }
    }
}

