/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v0_8;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v0_8.transport.AMQDataBlock;
import org.apache.qpid.server.transport.ByteBufferSender;

class CachedFrame
extends AMQDataBlock {
    private final String _toString;
    private final QpidByteBuffer _buffer;
    private final long _size;
    private boolean _disposed;

    CachedFrame(AMQDataBlock original) {
        this._toString = original.toString();
        this._size = original.getSize();
        this._buffer = QpidByteBuffer.allocate((boolean)true, (int)((int)this._size));
        original.writePayload(new BufferWriterSender(this._buffer));
        this._buffer.flip();
    }

    @Override
    public long getSize() {
        return this._size;
    }

    @Override
    public long writePayload(ByteBufferSender sender) {
        try (QpidByteBuffer dup = this._buffer.duplicate();){
            sender.send(dup);
        }
        return this._size;
    }

    public String toString() {
        return this._toString;
    }

    public void dispose() {
        this._buffer.dispose();
        this._disposed = true;
    }

    private static class BufferWriterSender
    implements ByteBufferSender {
        private final QpidByteBuffer _buffer;

        BufferWriterSender(QpidByteBuffer buffer) {
            this._buffer = buffer;
        }

        public boolean isDirectBufferPreferred() {
            return true;
        }

        public void send(QpidByteBuffer msg) {
            try (QpidByteBuffer dup = msg.duplicate();){
                this._buffer.put(dup);
            }
        }

        public void flush() {
        }

        public void close() {
        }
    }
}

