/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.sym;

import java.util.Locale;
import tools.jackson.core.sym.PropertyNameMatcher;

public abstract class HashedMatcherBase
extends PropertyNameMatcher {
    private static final long serialVersionUID = 1L;
    protected final int _mask;
    protected final int[] _offsets;
    protected final String[] _names;

    protected HashedMatcherBase(Locale locale, String[] names, int[] offsets, int mask, PropertyNameMatcher backup, String[] nameLookup) {
        super(locale, backup, nameLookup);
        this._names = names;
        this._offsets = offsets;
        this._mask = mask;
    }

    protected HashedMatcherBase(HashedMatcherBase base, String[] nameLookup) {
        this(base._locale, base._names, base._offsets, base._mask, base._backupMatcher, nameLookup);
    }

    protected HashedMatcherBase(HashedMatcherBase base, PropertyNameMatcher fallback) {
        this(base._locale, base._names, base._offsets, base._mask, fallback, base._nameLookup);
    }

    @Override
    public final int matchName(String toMatch) {
        int ix = HashedMatcherBase._hash(toMatch.hashCode(), this._mask);
        if (this._names[ix] == toMatch) {
            return this._offsets[ix];
        }
        int ix2 = this._mask + 1 + (ix >> 1);
        if (this._names[ix2] == toMatch) {
            return this._offsets[ix2];
        }
        return this._matchName2(toMatch, ix, ix2);
    }

    private final int _matchName2(String toMatch, int ix, int ix2) {
        String name = this._names[ix];
        if (toMatch.equals(name)) {
            return this._offsets[ix];
        }
        if (name != null) {
            name = this._names[ix2];
            if (toMatch.equals(name)) {
                return this._offsets[ix2];
            }
            if (name != null) {
                return this._matchSpill(toMatch);
            }
        }
        return this.matchSecondary(toMatch);
    }

    protected int _matchSpill(String toMatch) {
        int ix = this._mask + 1;
        ix += ix >> 1;
        int end = this._names.length;
        while (ix < end) {
            String name = this._names[ix];
            if (toMatch.equals(name)) {
                return this._offsets[ix];
            }
            if (name == null) break;
            ++ix;
        }
        return this.matchSecondary(toMatch);
    }

    public int spillCount() {
        int spillStart = this._mask + 1 + (this._mask + 1 >> 1);
        int count = 0;
        for (int i = spillStart; i < this._names.length; ++i) {
            if (this._names[i] == null) continue;
            ++count;
        }
        return count;
    }

    public int secondaryCount() {
        int spillStart = this._mask + 1 + (this._mask + 1 >> 1);
        int count = 0;
        for (int i = this._mask + 1; i < spillStart; ++i) {
            if (this._names[i] == null) continue;
            ++count;
        }
        return count;
    }
}

