/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.logging.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.FilterReply;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.qpid.server.logging.logback.LogBackLogInclusionRule;

public class CompositeFilter
extends Filter<ILoggingEvent> {
    private final List<Filter<ILoggingEvent>> _filterList = new CopyOnWriteArrayList<Filter<ILoggingEvent>>();
    private final AtomicLong _warnCount = new AtomicLong();
    private final AtomicLong _errorCount = new AtomicLong();

    public void addLogInclusionRule(LogBackLogInclusionRule logInclusionRule) {
        Filter<ILoggingEvent> f = logInclusionRule.asFilter();
        f.setName(logInclusionRule.getName());
        this._filterList.add(f);
    }

    public void removeLogInclusionRule(LogBackLogInclusionRule logInclusionRule) {
        for (Filter<ILoggingEvent> f : this._filterList) {
            if (!f.getName().equals(logInclusionRule.getName())) continue;
            this._filterList.remove(f);
            break;
        }
    }

    public FilterReply decide(ILoggingEvent event) {
        FilterReply reply = FilterReply.DENY;
        for (Filter<ILoggingEvent> filter : this._filterList) {
            FilterReply filterReply = filter.decide((Object)event);
            if (filterReply == FilterReply.DENY) {
                reply = filterReply;
                break;
            }
            if (filterReply != FilterReply.ACCEPT) continue;
            reply = filterReply;
        }
        if (reply == FilterReply.ACCEPT) {
            switch (event.getLevel().toInt()) {
                case 30000: {
                    this._warnCount.incrementAndGet();
                    break;
                }
                case 40000: {
                    this._errorCount.incrementAndGet();
                    break;
                }
            }
            return FilterReply.ACCEPT;
        }
        return FilterReply.DENY;
    }

    public long getErrorCount() {
        return this._errorCount.get();
    }

    public long getWarnCount() {
        return this._warnCount.get();
    }

    public void resetStatistics() {
        this._errorCount.set(0L);
        this._warnCount.set(0L);
    }
}

