/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.typedmessage.mimecontentconverter;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.server.message.mimecontentconverter.MimeContentToObjectConverter;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.typedmessage.TypedBytesContentReader;
import org.apache.qpid.server.typedmessage.TypedBytesFormatException;

@PluggableService
public class JmsMapMessageToMap
implements MimeContentToObjectConverter<Map> {
    @Override
    public String getType() {
        return this.getMimeType();
    }

    @Override
    public Class<Map> getObjectClass() {
        return Map.class;
    }

    @Override
    public String getMimeType() {
        return "jms/map-message";
    }

    @Override
    public Map toObject(byte[] data) {
        if (data == null || data.length == 0) {
            return Collections.emptyMap();
        }
        TypedBytesContentReader reader = new TypedBytesContentReader(ByteBuffer.wrap(data));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        int entries = reader.readIntImpl();
        for (int i = 0; i < entries; ++i) {
            try {
                String propName = reader.readStringImpl();
                Object value = reader.readObject();
                map.put(propName, value);
                continue;
            }
            catch (EOFException | TypedBytesFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return map;
    }
}

