/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security.auth;

import java.security.Principal;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.qpid.server.model.preferences.GenericPrincipal;
import org.apache.qpid.server.plugin.ConnectionPropertyEnricher;
import org.apache.qpid.server.plugin.PluggableService;
import org.apache.qpid.server.security.QpidPrincipal;
import org.apache.qpid.server.security.group.GroupPrincipal;
import org.apache.qpid.server.transport.AMQPConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluggableService
public class AuthIdentityConnectionPropertyEnricher
implements ConnectionPropertyEnricher {
    private static final Logger LOG = LoggerFactory.getLogger(AuthIdentityConnectionPropertyEnricher.class);

    @Override
    public Map<String, Object> addConnectionProperties(AMQPConnection<?> connection, Map<String, Object> existingProperties) {
        LinkedHashMap<String, Object> modifiedProperties = new LinkedHashMap<String, Object>(existingProperties);
        Principal principal = connection.getAuthorizedPrincipal();
        if (principal != null) {
            GenericPrincipal genericPrincipal = new GenericPrincipal((QpidPrincipal)principal);
            LinkedHashMap<String, String> claims = new LinkedHashMap<String, String>();
            claims.put("sub", genericPrincipal.toExternalForm());
            claims.put("preferred_username", genericPrincipal.getName());
            modifiedProperties.put("authenticated-identity", claims);
        }
        Set<GroupPrincipal> groups = connection.getSubject().getPrincipals(GroupPrincipal.class);
        List groupNames = groups.stream().map(GroupPrincipal::getName).collect(Collectors.toList());
        modifiedProperties.put("groups", groupNames);
        return Collections.unmodifiableMap(modifiedProperties);
    }

    @Override
    public String getType() {
        return "AUTH_IDENTITY";
    }
}

