/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.util.Collection;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.DerivedAttribute;
import org.apache.qpid.server.model.ManagedContextDefault;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedOperation;
import org.apache.qpid.server.model.NamedAddressSpace;

@ManagedObject(defaultType="ProvidedStore", description="<p>A virtualhost is a namespace in which messaging is performed. Virtualhosts are independent; the messaging goes on a within a virtualhost is independent of any messaging that goes on in another virtualhost. For instance, a queue named <i>foo</i> defined in one virtualhost is completely independent of a queue named <i>foo</i> in another virtualhost.</p><p>A virtualhost is backed by storage which is used to store the messages.</p>", amqpName="org.apache.qpid.VirtualHost")
public interface VirtualHost<X extends VirtualHost<X>>
extends ConfiguredObject<X>,
NamedAddressSpace {
    public static final String CLASS_DESCRIPTION = "<p>A virtualhost is a namespace in which messaging is performed. Virtualhosts are independent; the messaging goes on a within a virtualhost is independent of any messaging that goes on in another virtualhost. For instance, a queue named <i>foo</i> defined in one virtualhost is completely independent of a queue named <i>foo</i> in another virtualhost.</p><p>A virtualhost is backed by storage which is used to store the messages.</p>";
    public static final String MODEL_VERSION = "modelVersion";
    public static final String VIRTUALHOST_WORK_DIR_VAR = "virtualhost.work_dir";
    public static final String VIRTUALHOST_WORK_DIR_VAR_EXPRESSION = "${qpid.work_dir}${file.separator}${ancestor:virtualhost:name}";
    public static final String PREFERENCE_STORE_ATTRIBUTES = "preferenceStoreAttributes";
    @ManagedContextDefault(name="virtualhost.work_dir")
    public static final String VIRTUALHOST_WORK_DIR = "${qpid.work_dir}${file.separator}${ancestor:virtualhost:name}";

    @DerivedAttribute(persist=true)
    public String getModelVersion();

    @DerivedAttribute
    public String getProductVersion();

    @Override
    @ManagedOperation(nonModifying=true, changesConfiguredObjectState=false, associateAsIfChildren=true, skipAclCheck=true)
    public Collection<? extends Connection<?>> getConnections();
}

