/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.filter;

import org.apache.qpid.server.filter.BinaryExpression;
import org.apache.qpid.server.filter.Expression;
import org.apache.qpid.server.filter.SelectorParsingException;

public abstract class ArithmeticExpression<T>
extends BinaryExpression<T> {
    protected static final int INTEGER = 1;
    protected static final int LONG = 2;
    protected static final int DOUBLE = 3;

    public ArithmeticExpression(Expression<T> left, Expression<T> right) {
        super(left, right);
    }

    public static <E> Expression<E> createPlus(Expression<E> left, Expression<E> right) {
        return new ArithmeticExpression<E>((Expression)left, (Expression)right){

            @Override
            protected Object evaluate(Object lvalue, Object rvalue) {
                if (lvalue instanceof String) {
                    String text = (String)lvalue;
                    String answer = text + String.valueOf(rvalue);
                    return answer;
                }
                if (lvalue instanceof Number) {
                    return this.plus((Number)lvalue, this.asNumber(rvalue));
                }
                throw new SelectorParsingException("Cannot call plus operation on: " + String.valueOf(lvalue) + " and: " + String.valueOf(rvalue));
            }

            @Override
            public String getExpressionSymbol() {
                return "+";
            }
        };
    }

    public static <E> Expression<E> createMinus(Expression<E> left, Expression<E> right) {
        return new ArithmeticExpression<E>((Expression)left, (Expression)right){

            @Override
            protected Object evaluate(Object lvalue, Object rvalue) {
                if (lvalue instanceof Number) {
                    return this.minus((Number)lvalue, this.asNumber(rvalue));
                }
                throw new SelectorParsingException("Cannot call minus operation on: " + String.valueOf(lvalue) + " and: " + String.valueOf(rvalue));
            }

            @Override
            public String getExpressionSymbol() {
                return "-";
            }
        };
    }

    public static <E> Expression<E> createMultiply(Expression<E> left, Expression<E> right) {
        return new ArithmeticExpression<E>((Expression)left, (Expression)right){

            @Override
            protected Object evaluate(Object lvalue, Object rvalue) {
                if (lvalue instanceof Number) {
                    return this.multiply((Number)lvalue, this.asNumber(rvalue));
                }
                throw new SelectorParsingException("Cannot call multiply operation on: " + String.valueOf(lvalue) + " and: " + String.valueOf(rvalue));
            }

            @Override
            public String getExpressionSymbol() {
                return "*";
            }
        };
    }

    public static <E> Expression<E> createDivide(Expression<E> left, Expression<E> right) {
        return new ArithmeticExpression<E>((Expression)left, (Expression)right){

            @Override
            protected Object evaluate(Object lvalue, Object rvalue) {
                if (lvalue instanceof Number) {
                    return this.divide((Number)lvalue, this.asNumber(rvalue));
                }
                throw new SelectorParsingException("Cannot call divide operation on: " + String.valueOf(lvalue) + " and: " + String.valueOf(rvalue));
            }

            @Override
            public String getExpressionSymbol() {
                return "/";
            }
        };
    }

    public static <E> Expression<E> createMod(Expression<E> left, Expression<E> right) {
        return new ArithmeticExpression<E>((Expression)left, (Expression)right){

            @Override
            protected Object evaluate(Object lvalue, Object rvalue) {
                if (lvalue instanceof Number) {
                    return this.mod((Number)lvalue, this.asNumber(rvalue));
                }
                throw new SelectorParsingException("Cannot call mod operation on: " + String.valueOf(lvalue) + " and: " + String.valueOf(rvalue));
            }

            @Override
            public String getExpressionSymbol() {
                return "%";
            }
        };
    }

    protected Number plus(Number left, Number right) {
        switch (this.numberType(left, right)) {
            case 1: {
                return left.intValue() + right.intValue();
            }
            case 2: {
                return left.longValue() + right.longValue();
            }
        }
        return left.doubleValue() + right.doubleValue();
    }

    protected Number minus(Number left, Number right) {
        switch (this.numberType(left, right)) {
            case 1: {
                return left.intValue() - right.intValue();
            }
            case 2: {
                return left.longValue() - right.longValue();
            }
        }
        return left.doubleValue() - right.doubleValue();
    }

    protected Number multiply(Number left, Number right) {
        switch (this.numberType(left, right)) {
            case 1: {
                return left.intValue() * right.intValue();
            }
            case 2: {
                return left.longValue() * right.longValue();
            }
        }
        return left.doubleValue() * right.doubleValue();
    }

    protected Number divide(Number left, Number right) {
        return left.doubleValue() / right.doubleValue();
    }

    protected Number mod(Number left, Number right) {
        return left.doubleValue() % right.doubleValue();
    }

    private int numberType(Number left, Number right) {
        if (this.isDouble(left) || this.isDouble(right)) {
            return 3;
        }
        if (left instanceof Long || right instanceof Long) {
            return 2;
        }
        return 1;
    }

    private boolean isDouble(Number n) {
        return n instanceof Float || n instanceof Double;
    }

    protected Number asNumber(Object value) {
        if (value instanceof Number) {
            return (Number)value;
        }
        throw new SelectorParsingException("Cannot convert value: " + String.valueOf(value) + " into a number");
    }

    @Override
    public Object evaluate(T message) {
        Object lvalue = this.getLeft().evaluate(message);
        if (lvalue == null) {
            return null;
        }
        Object rvalue = this.getRight().evaluate(message);
        if (rvalue == null) {
            return null;
        }
        return this.evaluate(lvalue, rvalue);
    }

    protected abstract Object evaluate(Object var1, Object var2);
}

