/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ser.jdk;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.jdk.CollectionSerializer;
import tools.jackson.databind.ser.std.StdSerializer;

public abstract class StaticListSerializerBase<T extends Collection<?>>
extends StdSerializer<T> {
    protected final Boolean _unwrapSingle;

    protected StaticListSerializerBase(Class<?> cls) {
        super(cls);
        this._unwrapSingle = null;
    }

    protected StaticListSerializerBase(StaticListSerializerBase<?> src, Boolean unwrapSingle) {
        super(src);
        this._unwrapSingle = unwrapSingle;
    }

    public abstract ValueSerializer<?> _withResolved(BeanProperty var1, Boolean var2);

    @Override
    public ValueSerializer<?> createContextual(SerializationContext serializers, BeanProperty property) {
        ValueSerializer<Object> ser = null;
        if (property != null) {
            AnnotationIntrospector intr = serializers.getAnnotationIntrospector();
            AnnotatedMember m = property.getMember();
            if (m != null) {
                ser = serializers.serializerInstance(m, intr.findContentSerializer(serializers.getConfig(), m));
            }
        }
        Boolean unwrapSingle = null;
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, this.handledType());
        if (format != null) {
            unwrapSingle = format.getFeature(JsonFormat.Feature.WRITE_SINGLE_ELEM_ARRAYS_UNWRAPPED);
        }
        if ((ser = this.findContextualConvertingSerializer(serializers, property, ser)) == null) {
            ser = serializers.findContentValueSerializer(String.class, property);
        }
        if (this.isDefaultSerializer(ser)) {
            if (Objects.equals(unwrapSingle, this._unwrapSingle)) {
                return this;
            }
            return this._withResolved(property, unwrapSingle);
        }
        return new CollectionSerializer(serializers.constructType((Type)((Object)String.class)), true, null, ser);
    }

    @Override
    public boolean isEmpty(SerializationContext provider, T value) {
        return value == null || value.isEmpty();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            this.acceptContentVisitor(v2);
        }
    }

    protected abstract JsonNode contentSchema();

    protected abstract void acceptContentVisitor(JsonArrayFormatVisitor var1);

    @Override
    public abstract void serializeWithType(T var1, JsonGenerator var2, SerializationContext var3, TypeSerializer var4) throws JacksonException;
}

