/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.set;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.expression.AbstractExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.set.SetExpression;
import org.apache.qpid.server.query.engine.parsing.query.ProjectionExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;

public abstract class AbstractSetExpression<T, R>
extends AbstractExpressionNode<T, R>
implements SetExpression<T, R> {
    protected boolean _distinct;

    public AbstractSetExpression(boolean distinct) {
        this._distinct = distinct;
    }

    public AbstractSetExpression(boolean distinct, ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        super(left, right);
        this._distinct = distinct;
        SetExpression leftExpression = (SetExpression)left;
        SetExpression rightExpression = (SetExpression)right;
        List leftProjections = leftExpression.getProjections();
        List rightProjections = rightExpression.getProjections();
        if (leftExpression.getProjections().size() != rightProjections.size()) {
            throw QueryParsingException.of("Products of '%s' operation have different length", this.getClass().getSimpleName().toLowerCase(Locale.US).replace("expression", ""));
        }
        for (int i = 0; i < leftProjections.size(); ++i) {
            ProjectionExpression leftProjection = leftProjections.get(i);
            ProjectionExpression rightProjection = rightProjections.get(i);
            rightProjection.setAlias(leftProjection.getAlias());
        }
    }

    @Override
    public List<ProjectionExpression<T, R>> getProjections() {
        SetExpression left = (SetExpression)this.getChild(0);
        return left.getProjections();
    }

    @Override
    public List<SelectExpression<T, R>> getSelections() {
        ArrayList<SelectExpression<T, R>> result = new ArrayList<SelectExpression<T, R>>();
        this.getChildSelections(this, result);
        return result;
    }

    private void getChildSelections(SetExpression<T, R> setExpression, List<SelectExpression<T, R>> result) {
        if (setExpression instanceof SelectExpression) {
            result.add((SelectExpression)setExpression);
            return;
        }
        for (ExpressionNode child : setExpression.getChildren()) {
            if (!(child instanceof SetExpression)) continue;
            this.getChildSelections((SetExpression)child, result);
        }
    }
}

