/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.function.string;

import java.util.List;
import java.util.Optional;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;
import org.apache.qpid.server.query.engine.validation.FunctionParametersValidator;

public class PositionExpression<T, R>
extends AbstractFunctionExpression<T, Integer> {
    private final FunctionParameterTypePredicate<R> _arg1Validator = FunctionParameterTypePredicate.builder().allowBooleans().allowEnums().allowDateTimeTypes().allowNumbers().allowStrings().build();

    public PositionExpression(String alias, List<ExpressionNode<T, ?>> args) {
        super(alias, args);
        FunctionParametersValidator.requireMinParameters(2, args, this);
        FunctionParametersValidator.requireMaxParameters(3, args, this);
    }

    @Override
    public Integer apply(T value) {
        String convertedSource;
        String convertedSubstring;
        R searchPattern = this.evaluateChild(0, value, this._arg1Validator);
        R source = this.evaluateChild(1, value, this._arg1Validator);
        ExpressionNode searchFromExpression = this.getChild(2);
        Object searchFrom = searchFromExpression == null ? null : Optional.ofNullable(searchFromExpression.apply(value)).orElseThrow(() -> QueryEvaluationException.functionParameterLessThanOne(this._functionName, 3));
        if (source == null) {
            return 0;
        }
        String string = convertedSubstring = DateTimeConverter.isDateTime(searchPattern) ? DateTimeConverter.toStringMapper().apply(searchPattern) : String.valueOf(searchPattern);
        if (convertedSubstring.isEmpty()) {
            throw QueryEvaluationException.emptyFunctionParameter(this._functionName, 1);
        }
        String string2 = convertedSource = DateTimeConverter.isDateTime(source) ? DateTimeConverter.toStringMapper().apply(source) : String.valueOf(source);
        if (searchFrom != null) {
            if (!(searchFrom instanceof Integer) || (Integer)searchFrom < 1) {
                throw QueryEvaluationException.functionParameterLessThanOne(this._functionName, 3);
            }
            return convertedSource.indexOf(convertedSubstring, (Integer)searchFrom - 1) + 1;
        }
        return convertedSource.indexOf(convertedSubstring) + 1;
    }
}

