/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.comparison;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.UUID;
import org.apache.qpid.server.query.engine.exception.QueryEvaluationException;
import org.apache.qpid.server.query.engine.parsing.converter.DateTimeConverter;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.AbstractComparisonExpression;
import org.apache.qpid.server.query.engine.parsing.expression.set.EmptySetExpression;
import org.apache.qpid.server.query.engine.parsing.utils.StringUtils;
import org.apache.qpid.server.query.engine.validation.FunctionParameterTypePredicate;

public class EqualExpression<T, R>
extends AbstractComparisonExpression<T, Boolean> {
    private final FunctionParameterTypePredicate<R> _typeValidator = FunctionParameterTypePredicate.builder().allowBooleans().allowDateTimeTypes().allowEnums().allowNumbers().allowComparables().allowStrings().build();

    public EqualExpression(ExpressionNode<T, R> left, ExpressionNode<T, R> right) {
        super(left, right);
        this._operator = "=";
    }

    @Override
    public Boolean apply(T value) {
        Object left = this.evaluateChild(0, value);
        Object right = this.evaluateChild(1, value);
        if (right instanceof EmptySetExpression) {
            return Boolean.FALSE;
        }
        if (!this._typeValidator.test(left) || !this._typeValidator.test(right)) {
            throw QueryEvaluationException.of("Objects of types '%s' and '%s' can not be compared", StringUtils.getClassName(left), StringUtils.getClassName(right));
        }
        if (left == null ^ right == null) {
            return Boolean.FALSE;
        }
        if (left == right || Objects.equals(left, right)) {
            return Boolean.TRUE;
        }
        if (left instanceof Number && right instanceof Number) {
            return new BigDecimal(String.valueOf(left)).compareTo(new BigDecimal(String.valueOf(right))) == 0;
        }
        if (left.getClass().isEnum() && right instanceof String) {
            return Objects.equals(left.toString(), right);
        }
        if (left instanceof UUID && right instanceof String) {
            return Objects.equals(left.toString(), right);
        }
        if (DateTimeConverter.isDateTime(left) || DateTimeConverter.isDateTime(right)) {
            return DateTimeConverter.toInstantMapper().apply(left).equals(DateTimeConverter.toInstantMapper().apply(right));
        }
        return Boolean.FALSE;
    }
}

