/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.shared.common.error.StandardException;

class DropTriggerNode
extends DDLStatementNode {
    private TableDescriptor td;

    DropTriggerNode(TableName tableName, ContextManager contextManager) {
        super(tableName, contextManager);
    }

    @Override
    String statementToString() {
        return "DROP TRIGGER";
    }

    @Override
    public void bindStatement() throws StandardException {
        CompilerContext compilerContext = this.getCompilerContext();
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor schemaDescriptor = this.getSchemaDescriptor();
        TriggerDescriptor triggerDescriptor = null;
        if (schemaDescriptor.getUUID() != null) {
            triggerDescriptor = dataDictionary.getTriggerDescriptor(this.getRelativeName(), schemaDescriptor);
        }
        if (triggerDescriptor == null) {
            throw StandardException.newException((String)"42X94", (Object[])new Object[]{"TRIGGER", this.getFullName()});
        }
        this.td = triggerDescriptor.getTableDescriptor();
        compilerContext.createDependency(this.td);
        compilerContext.createDependency(triggerDescriptor);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getDropTriggerConstantAction(this.getSchemaDescriptor(), this.getRelativeName(), this.td.getUUID());
    }
}

