/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core.json;

import java.io.DataInput;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import tools.jackson.core.ErrorReportConfiguration;
import tools.jackson.core.FormatFeature;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonEncoding;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.ObjectReadContext;
import tools.jackson.core.ObjectWriteContext;
import tools.jackson.core.SerializableString;
import tools.jackson.core.StreamReadConstraints;
import tools.jackson.core.StreamWriteConstraints;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.core.Version;
import tools.jackson.core.base.TextualTSFactory;
import tools.jackson.core.io.CharacterEscapes;
import tools.jackson.core.io.ContentReference;
import tools.jackson.core.io.IOContext;
import tools.jackson.core.json.ByteSourceJsonBootstrapper;
import tools.jackson.core.json.JsonFactoryBuilder;
import tools.jackson.core.json.JsonReadFeature;
import tools.jackson.core.json.JsonWriteFeature;
import tools.jackson.core.json.PackageVersion;
import tools.jackson.core.json.ReaderBasedJsonParser;
import tools.jackson.core.json.UTF8DataInputJsonParser;
import tools.jackson.core.json.UTF8JsonGenerator;
import tools.jackson.core.json.WriterBasedJsonGenerator;
import tools.jackson.core.json.async.NonBlockingByteArrayJsonParser;
import tools.jackson.core.json.async.NonBlockingByteBufferJsonParser;
import tools.jackson.core.sym.BinaryNameMatcher;
import tools.jackson.core.sym.ByteQuadsCanonicalizer;
import tools.jackson.core.sym.CharsToNameCanonicalizer;
import tools.jackson.core.sym.PropertyNameMatcher;
import tools.jackson.core.util.DefaultPrettyPrinter;
import tools.jackson.core.util.Named;

public class JsonFactory
extends TextualTSFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String FORMAT_NAME_JSON = "JSON";
    static final int DEFAULT_JSON_PARSER_FEATURE_FLAGS = JsonReadFeature.collectDefaults();
    static final int DEFAULT_JSON_GENERATOR_FEATURE_FLAGS = JsonWriteFeature.collectDefaults();
    public static final SerializableString DEFAULT_ROOT_VALUE_SEPARATOR = DefaultPrettyPrinter.DEFAULT_ROOT_VALUE_SEPARATOR;
    public static final char DEFAULT_QUOTE_CHAR = '\"';
    protected final CharacterEscapes _characterEscapes;
    protected final SerializableString _rootValueSeparator;
    protected final int _maximumNonEscapedChar;
    protected final char _quoteChar;
    protected final transient CharsToNameCanonicalizer _rootCharSymbols;
    protected final transient ByteQuadsCanonicalizer _byteSymbolCanonicalizer = ByteQuadsCanonicalizer.createRoot();

    public JsonFactory() {
        super(StreamReadConstraints.defaults(), StreamWriteConstraints.defaults(), ErrorReportConfiguration.defaults(), DEFAULT_JSON_PARSER_FEATURE_FLAGS, DEFAULT_JSON_GENERATOR_FEATURE_FLAGS);
        this._rootValueSeparator = DEFAULT_ROOT_VALUE_SEPARATOR;
        this._characterEscapes = null;
        this._maximumNonEscapedChar = 0;
        this._quoteChar = (char)34;
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot(this);
    }

    protected JsonFactory(JsonFactory src) {
        super(src);
        this._rootValueSeparator = src._rootValueSeparator;
        this._characterEscapes = src._characterEscapes;
        this._maximumNonEscapedChar = src._maximumNonEscapedChar;
        this._quoteChar = src._quoteChar;
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot(this);
    }

    protected JsonFactory(JsonFactoryBuilder b) {
        super(b);
        this._rootValueSeparator = b.rootValueSeparator();
        this._characterEscapes = b.characterEscapes();
        this._maximumNonEscapedChar = b.highestNonEscapedChar();
        this._quoteChar = b.quoteChar();
        this._rootCharSymbols = CharsToNameCanonicalizer.createRoot(this);
    }

    public JsonFactoryBuilder rebuild() {
        return new JsonFactoryBuilder(this);
    }

    public static JsonFactoryBuilder builder() {
        return new JsonFactoryBuilder();
    }

    public static JsonFactoryBuilder builderWithJackson2Defaults() {
        return JsonFactory.builder().configureForJackson2();
    }

    @Override
    public JsonFactory copy() {
        return new JsonFactory(this);
    }

    @Override
    public TokenStreamFactory snapshot() {
        return this;
    }

    protected Object readResolve() {
        return new JsonFactory(this);
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    @Override
    public boolean canParseAsync() {
        return true;
    }

    public final boolean isEnabled(JsonReadFeature f) {
        return (this._formatReadFeatures & f.getMask()) != 0;
    }

    public final boolean isEnabled(JsonWriteFeature f) {
        return (this._formatWriteFeatures & f.getMask()) != 0;
    }

    @Override
    public boolean canUseSchema(FormatSchema schema) {
        return false;
    }

    @Override
    public String getFormatName() {
        return FORMAT_NAME_JSON;
    }

    @Override
    public Class<? extends FormatFeature> getFormatReadFeatureType() {
        return JsonReadFeature.class;
    }

    @Override
    public Class<? extends FormatFeature> getFormatWriteFeatureType() {
        return JsonWriteFeature.class;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    public String getRootValueSeparator() {
        return this._rootValueSeparator == null ? null : this._rootValueSeparator.getValue();
    }

    public JsonParser createNonBlockingByteArrayParser(ObjectReadContext readCtxt) {
        IOContext ioCtxt = this._createNonBlockingContext(null);
        ByteQuadsCanonicalizer can = this._byteSymbolCanonicalizer.makeChildOrPlaceholder(this._factoryFeatures);
        return new NonBlockingByteArrayJsonParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), can);
    }

    public JsonParser createNonBlockingByteBufferParser(ObjectReadContext readCtxt) {
        IOContext ioCtxt = this._createNonBlockingContext(null);
        ByteQuadsCanonicalizer can = this._byteSymbolCanonicalizer.makeChildOrPlaceholder(this._factoryFeatures);
        return new NonBlockingByteBufferJsonParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), can);
    }

    protected IOContext _createNonBlockingContext(Object srcRef) {
        return new IOContext(this._streamReadConstraints, this._streamWriteConstraints, this._errorReportConfiguration, this._getBufferRecycler(), ContentReference.rawReference(srcRef), false, JsonEncoding.UTF8);
    }

    @Override
    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, InputStream in) throws JacksonException {
        try {
            return new ByteSourceJsonBootstrapper(ioCtxt, in).constructParser(readCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._byteSymbolCanonicalizer, this._rootCharSymbols, this._factoryFeatures);
        }
        catch (RuntimeException e) {
            if (ioCtxt.isResourceManaged()) {
                try {
                    in.close();
                }
                catch (Exception e2) {
                    e.addSuppressed(e2);
                }
            }
            throw e;
        }
    }

    @Override
    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, Reader r) throws JacksonException {
        return new ReaderBasedJsonParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), r, this._rootCharSymbols.makeChild());
    }

    @Override
    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, char[] data, int offset, int len, boolean recyclable) throws JacksonException {
        this._checkRangeBoundsForCharArray(data, offset, len);
        return new ReaderBasedJsonParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), null, this._rootCharSymbols.makeChild(), data, offset, offset + len, recyclable);
    }

    @Override
    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, byte[] data, int offset, int len) throws JacksonException {
        this._checkRangeBoundsForByteArray(data, offset, len);
        return new ByteSourceJsonBootstrapper(ioCtxt, data, offset, len).constructParser(readCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), this._byteSymbolCanonicalizer, this._rootCharSymbols, this._factoryFeatures);
    }

    @Override
    protected JsonParser _createParser(ObjectReadContext readCtxt, IOContext ioCtxt, DataInput input) throws JacksonException {
        int firstByte = ByteSourceJsonBootstrapper.skipUTF8BOM(input);
        ByteQuadsCanonicalizer can = this._byteSymbolCanonicalizer.makeChildOrPlaceholder(this._factoryFeatures);
        return new UTF8DataInputJsonParser(readCtxt, ioCtxt, readCtxt.getStreamReadFeatures(this._streamReadFeatures), readCtxt.getFormatReadFeatures(this._formatReadFeatures), input, can, firstByte);
    }

    @Override
    protected JsonGenerator _createGenerator(ObjectWriteContext writeCtxt, IOContext ioCtxt, Writer out) throws JacksonException {
        SerializableString rootSep = writeCtxt.getRootValueSeparator(this._rootValueSeparator);
        CharacterEscapes charEsc = writeCtxt.getCharacterEscapes();
        if (charEsc == null) {
            charEsc = this._characterEscapes;
        }
        int maxNonEscaped = this._maximumNonEscapedChar;
        return new WriterBasedJsonGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures), out, rootSep, writeCtxt.getPrettyPrinter(), charEsc, maxNonEscaped, this._quoteChar);
    }

    @Override
    protected JsonGenerator _createUTF8Generator(ObjectWriteContext writeCtxt, IOContext ioCtxt, OutputStream out) throws JacksonException {
        SerializableString rootSep = writeCtxt.getRootValueSeparator(this._rootValueSeparator);
        CharacterEscapes charEsc = writeCtxt.getCharacterEscapes();
        if (charEsc == null) {
            charEsc = this._characterEscapes;
        }
        int maxNonEscaped = this._maximumNonEscapedChar;
        return new UTF8JsonGenerator(writeCtxt, ioCtxt, writeCtxt.getStreamWriteFeatures(this._streamWriteFeatures), writeCtxt.getFormatWriteFeatures(this._formatWriteFeatures), out, rootSep, charEsc, writeCtxt.getPrettyPrinter(), maxNonEscaped, this._quoteChar);
    }

    @Override
    public PropertyNameMatcher constructNameMatcher(List<Named> matches, boolean alreadyInterned) {
        return BinaryNameMatcher.constructFrom(matches, alreadyInterned);
    }

    @Override
    public PropertyNameMatcher constructCINameMatcher(List<Named> matches, boolean alreadyInterned, Locale locale) {
        return BinaryNameMatcher.constructCaseInsensitive(locale, matches, alreadyInterned);
    }
}

