/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.internal;

import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Fields;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.core.ExtensionConfig;
import org.eclipse.jetty.websocket.core.server.ServerUpgradeRequest;

public class CompletedUpgradeRequest
implements UpgradeRequest {
    private final HttpFields _httpFields;
    private final List<org.eclipse.jetty.websocket.api.ExtensionConfig> _extensions;
    private final HttpURI _httpURI;
    private final String _httpVersion;
    private final String _method;
    private final List<String> _subProtocols;
    private final boolean _secure;
    private final String _protocolVersion;
    private final Principal _userPrincipal;
    private List<HttpCookie> _jettyCookies;
    private List<java.net.HttpCookie> _cookies;
    private Fields _queryFields;
    private Map<String, List<String>> _queryParams;

    public CompletedUpgradeRequest(ServerUpgradeRequest request) {
        this._httpFields = request.getHeaders().asImmutable();
        this._httpURI = request.getHttpURI();
        this._method = request.getMethod();
        this._httpVersion = request.getConnectionMetaData().getHttpVersion().asString();
        this._subProtocols = request.getSubProtocols();
        this._secure = request.isSecure();
        this._protocolVersion = request.getProtocolVersion();
        this._jettyCookies = Request.getCookies((Request)request);
        this._queryFields = Request.extractQueryParameters((Request)request);
        ArrayList<JettyExtensionConfig> extensions = new ArrayList<JettyExtensionConfig>();
        for (ExtensionConfig extension : request.getExtensions()) {
            extensions.add(new JettyExtensionConfig(extension));
        }
        this._extensions = Collections.unmodifiableList(extensions);
        this._userPrincipal = Request.getAuthenticationState((Request)request).getUserPrincipal();
    }

    public List<java.net.HttpCookie> getCookies() {
        if (this._cookies == null) {
            ArrayList<java.net.HttpCookie> cookies = new ArrayList<java.net.HttpCookie>();
            for (HttpCookie cookie : this._jettyCookies) {
                cookies.add(HttpCookie.asJavaNetHttpCookie((HttpCookie)cookie));
            }
            this._cookies = Collections.unmodifiableList(cookies);
            this._jettyCookies = null;
        }
        return this._cookies;
    }

    public List<org.eclipse.jetty.websocket.api.ExtensionConfig> getExtensions() {
        return this._extensions;
    }

    public String getHeader(String name) {
        return this._httpFields.get(name);
    }

    public int getHeaderInt(String name) {
        HttpField field = this._httpFields.getField(name);
        return field == null ? -1 : field.getIntValue();
    }

    public Map<String, List<String>> getHeaders() {
        return HttpFields.asMap((HttpFields)this._httpFields);
    }

    public List<String> getHeaders(String name) {
        return this._httpFields.getValuesList(name);
    }

    public String getHost() {
        return this._httpURI.getHost();
    }

    public String getHttpVersion() {
        return this._httpVersion;
    }

    public String getMethod() {
        return this._method;
    }

    public String getOrigin() {
        return this._httpFields.get(HttpHeader.ORIGIN);
    }

    public Map<String, List<String>> getParameterMap() {
        if (this._queryParams == null) {
            LinkedHashMap<String, List> queryParams = new LinkedHashMap<String, List>();
            for (Fields.Field field : this._queryFields) {
                queryParams.put(field.getName(), field.getValues());
            }
            this._queryParams = Collections.unmodifiableMap(queryParams);
            this._queryFields = null;
        }
        return this._queryParams;
    }

    public String getProtocolVersion() {
        return this._protocolVersion;
    }

    public String getQueryString() {
        return this._httpURI.getQuery();
    }

    public URI getRequestURI() {
        HttpURI.Mutable wsURI = HttpURI.build((HttpURI)this._httpURI);
        wsURI.scheme(HttpScheme.isSecure((String)this._httpURI.getScheme()) ? HttpScheme.WSS : HttpScheme.WS);
        return wsURI.toURI();
    }

    public List<String> getSubProtocols() {
        return this._subProtocols;
    }

    public Principal getUserPrincipal() {
        return this._userPrincipal;
    }

    public boolean hasSubProtocol(String subProtocol) {
        return this._subProtocols.stream().anyMatch(s -> s.equalsIgnoreCase(subProtocol));
    }

    public boolean isSecure() {
        return this._secure;
    }
}

