/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LocalCacheFactory;
import com.github.benmanes.caffeine.cache.SSMSW;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

final class SSMSWR<K, V>
extends SSMSW<K, V> {
    static final LocalCacheFactory FACTORY = SSMSWR::new;
    private static final VarHandle REFRESH_AFTER_WRITE_NANOS;
    volatile long refreshAfterWriteNanos;

    SSMSWR(Caffeine<K, V> caffeine, AsyncCacheLoader<? super K, V> asyncCacheLoader, boolean bl) {
        super(caffeine, asyncCacheLoader, bl);
        this.setRefreshAfterWriteNanos(caffeine.getRefreshAfterWriteNanos());
    }

    @Override
    protected boolean refreshAfterWrite() {
        return true;
    }

    @Override
    protected long refreshAfterWriteNanos() {
        return REFRESH_AFTER_WRITE_NANOS.getAcquire(this);
    }

    @Override
    protected void setRefreshAfterWriteNanos(long l) {
        REFRESH_AFTER_WRITE_NANOS.setRelease(this, l);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            REFRESH_AFTER_WRITE_NANOS = lookup.findVarHandle(SSMSWR.class, "refreshAfterWriteNanos", Long.TYPE);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new ExceptionInInitializerError(reflectiveOperationException);
        }
    }
}

