/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb.replication;

import com.sleepycat.bind.tuple.IntegerBinding;
import com.sleepycat.bind.tuple.LongBinding;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.Durability;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePinger {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabasePinger.class);
    public static final String PING_DATABASE_NAME = "PINGDB";
    private static final DatabaseConfig DATABASE_CONFIG = DatabaseConfig.DEFAULT.setAllowCreate(true).setTransactional(true);
    private static final int ID = 0;
    private final TransactionConfig _pingTransactionConfig = new TransactionConfig();

    public DatabasePinger() {
        this._pingTransactionConfig.setDurability(new Durability(Durability.SyncPolicy.NO_SYNC, Durability.SyncPolicy.NO_SYNC, Durability.ReplicaAckPolicy.SIMPLE_MAJORITY));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pingDb(EnvironmentFacade facade) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Beginning ping transaction");
            }
            Database db = facade.openDatabase(PING_DATABASE_NAME, DATABASE_CONFIG);
            DatabaseEntry key = new DatabaseEntry();
            IntegerBinding.intToEntry((int)0, (DatabaseEntry)key);
            DatabaseEntry value = new DatabaseEntry();
            LongBinding.longToEntry((long)System.currentTimeMillis(), (DatabaseEntry)value);
            Transaction txn = null;
            try {
                txn = facade.beginTransaction(this._pingTransactionConfig);
                db.put(txn, key, value);
                txn.commit();
                txn = null;
            }
            finally {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Ping transaction completed");
                }
                if (txn != null) {
                    txn.abort();
                }
            }
        }
        catch (RuntimeException de) {
            RuntimeException handledException = facade.handleDatabaseException("DatabaseException from DatabasePinger ", de);
            LOGGER.debug("Non fatal exception on invoking DatabasePinger. Ignoring...", (Throwable)handledException);
        }
    }
}

