/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.store.berkeleydb;

import java.io.File;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.store.FileBasedSettings;
import org.apache.qpid.server.store.StoreException;
import org.apache.qpid.server.store.berkeleydb.AbstractBDBMessageStore;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacade;
import org.apache.qpid.server.store.berkeleydb.EnvironmentFacadeFactory;
import org.apache.qpid.server.store.berkeleydb.StandardEnvironmentFacadeFactory;
import org.apache.qpid.server.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BDBMessageStore
extends AbstractBDBMessageStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(BDBMessageStore.class);
    private final EnvironmentFacadeFactory _environmentFacadeFactory;
    private EnvironmentFacade _environmentFacade;

    public BDBMessageStore() {
        this(new StandardEnvironmentFacadeFactory());
    }

    public BDBMessageStore(EnvironmentFacadeFactory environmentFacadeFactory) {
        this._environmentFacadeFactory = environmentFacadeFactory;
    }

    @Override
    protected void doOpen(ConfiguredObject<?> parent) {
        this._environmentFacade = this._environmentFacadeFactory.createEnvironmentFacade(parent);
    }

    @Override
    protected void doClose() {
        if (this._environmentFacade != null) {
            try {
                this._environmentFacade.close();
                this._environmentFacade = null;
            }
            catch (RuntimeException e) {
                throw new StoreException("Exception occurred on message store close", (Throwable)e);
            }
        }
    }

    public void onDelete(ConfiguredObject<?> parent) {
        if (this.isMessageStoreOpen()) {
            throw new IllegalStateException("Cannot delete the store as store is still open");
        }
        FileBasedSettings fileBasedSettings = (FileBasedSettings)parent;
        String storePath = fileBasedSettings.getStorePath();
        if (storePath != null) {
            File configFile;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleting store : {}", (Object)storePath);
            }
            if (!FileUtils.delete((File)(configFile = new File(storePath)), (boolean)true)) {
                LOGGER.info("Failed to delete the store at location : {} ", (Object)storePath);
            }
        }
    }

    @Override
    public EnvironmentFacade getEnvironmentFacade() {
        return this._environmentFacade;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public String getStoreLocation() {
        return ((FileBasedSettings)this.getParent()).getStorePath();
    }

    public File getStoreLocationAsFile() {
        return new File(this.getStoreLocation());
    }
}

