/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.v1_0.type.transport;

import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.protocol.v1_0.CompositeType;
import org.apache.qpid.server.protocol.v1_0.CompositeTypeField;
import org.apache.qpid.server.protocol.v1_0.ConnectionHandler;
import org.apache.qpid.server.protocol.v1_0.type.Binary;
import org.apache.qpid.server.protocol.v1_0.type.DeliveryState;
import org.apache.qpid.server.protocol.v1_0.type.FrameBody;
import org.apache.qpid.server.protocol.v1_0.type.UnsignedInteger;
import org.apache.qpid.server.protocol.v1_0.type.transport.ReceiverSettleMode;

@CompositeType(symbolicDescriptor="amqp:transfer:list", numericDescriptor=20L)
public class Transfer
implements FrameBody {
    private volatile QpidByteBuffer _payload;
    @CompositeTypeField(index=0, mandatory=true)
    private UnsignedInteger _handle;
    @CompositeTypeField(index=1)
    private UnsignedInteger _deliveryId;
    @CompositeTypeField(index=2)
    private Binary _deliveryTag;
    @CompositeTypeField(index=3)
    private UnsignedInteger _messageFormat;
    @CompositeTypeField(index=4)
    private Boolean _settled;
    @CompositeTypeField(index=5)
    private Boolean _more;
    @CompositeTypeField(index=6)
    private ReceiverSettleMode _rcvSettleMode;
    @CompositeTypeField(index=7)
    private DeliveryState _state;
    @CompositeTypeField(index=8)
    private Boolean _resume;
    @CompositeTypeField(index=9)
    private Boolean _aborted;
    @CompositeTypeField(index=10)
    private Boolean _batchable;

    public UnsignedInteger getHandle() {
        return this._handle;
    }

    public void setHandle(UnsignedInteger handle) {
        this._handle = handle;
    }

    public UnsignedInteger getDeliveryId() {
        return this._deliveryId;
    }

    public void setDeliveryId(UnsignedInteger deliveryId) {
        this._deliveryId = deliveryId;
    }

    public Binary getDeliveryTag() {
        return this._deliveryTag;
    }

    public void setDeliveryTag(Binary deliveryTag) {
        this._deliveryTag = deliveryTag;
    }

    public UnsignedInteger getMessageFormat() {
        return this._messageFormat;
    }

    public void setMessageFormat(UnsignedInteger messageFormat) {
        this._messageFormat = messageFormat;
    }

    public Boolean getSettled() {
        return this._settled;
    }

    public void setSettled(Boolean settled) {
        this._settled = settled;
    }

    public Boolean getMore() {
        return this._more;
    }

    public void setMore(Boolean more) {
        this._more = more;
    }

    public ReceiverSettleMode getRcvSettleMode() {
        return this._rcvSettleMode;
    }

    public void setRcvSettleMode(ReceiverSettleMode rcvSettleMode) {
        this._rcvSettleMode = rcvSettleMode;
    }

    public DeliveryState getState() {
        return this._state;
    }

    public void setState(DeliveryState state) {
        this._state = state;
    }

    public Boolean getResume() {
        return this._resume;
    }

    public void setResume(Boolean resume) {
        this._resume = resume;
    }

    public Boolean getAborted() {
        return this._aborted;
    }

    public void setAborted(Boolean aborted) {
        this._aborted = aborted;
    }

    public Boolean getBatchable() {
        return this._batchable;
    }

    public void setBatchable(Boolean batchable) {
        this._batchable = batchable;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Transfer{");
        int origLength = builder.length();
        if (this._handle != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("handle=").append(this._handle);
        }
        if (this._deliveryId != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("deliveryId=").append(this._deliveryId);
        }
        if (this._deliveryTag != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("deliveryTag=").append(this._deliveryTag);
        }
        if (this._messageFormat != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("messageFormat=").append(this._messageFormat);
        }
        if (this._settled != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("settled=").append(this._settled);
        }
        if (this._more != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("more=").append(this._more);
        }
        if (this._rcvSettleMode != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("rcvSettleMode=").append(this._rcvSettleMode);
        }
        if (this._state != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("state=").append(this._state);
        }
        if (this._resume != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("resume=").append(this._resume);
        }
        if (this._aborted != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("aborted=").append(this._aborted);
        }
        if (this._batchable != null) {
            if (builder.length() != origLength) {
                builder.append(',');
            }
            builder.append("batchable=").append(this._batchable);
        }
        builder.append('}');
        return builder.toString();
    }

    @Override
    public void invoke(int channel, ConnectionHandler conn) {
        conn.receiveTransfer(channel, this);
    }

    public QpidByteBuffer getPayload() {
        if (this._payload == null) {
            return null;
        }
        return this._payload.duplicate();
    }

    public void setPayload(QpidByteBuffer payload) {
        this._payload = payload == null ? null : payload.duplicate();
    }

    public void dispose() {
        if (this._payload != null) {
            this._payload.dispose();
            this._payload = null;
        }
    }
}

