/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.scalar.timetz;

import io.trino.spi.function.LiteralParameter;
import io.trino.spi.function.LiteralParameters;
import io.trino.spi.function.OperatorType;
import io.trino.spi.function.ScalarOperator;
import io.trino.spi.function.SqlType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimeWithTimeZone;
import io.trino.type.DateTimes;

@ScalarOperator(value=OperatorType.CAST)
public final class TimeWithTimeZoneToTimeCast {
    private TimeWithTimeZoneToTimeCast() {
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long cast(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision) with time zone") long packedTime) {
        return TimeWithTimeZoneToTimeCast.convert(targetPrecision, DateTimeEncoding.unpackTimeNanos((long)packedTime) * 1000L);
    }

    @LiteralParameters(value={"sourcePrecision", "targetPrecision"})
    @SqlType(value="time(targetPrecision)")
    public static long cast(@LiteralParameter(value="targetPrecision") long targetPrecision, @SqlType(value="time(sourcePrecision) with time zone") LongTimeWithTimeZone timestamp) {
        return TimeWithTimeZoneToTimeCast.convert(targetPrecision, timestamp.getPicoseconds());
    }

    private static long convert(long targetPrecision, long picos) {
        return DateTimes.round(picos, (int)(12L - targetPrecision)) % 86400000000000000L;
    }
}

